/*
 * Decompiled with CFR 0.152.
 */
package snownee.passablefoliage.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.passablefoliage.PassableFoliage;
import snownee.passablefoliage.PassableFoliageCommonConfig;
import snownee.passablefoliage.mixin.BlockBehaviourAccess;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public class BlockStateMixin {
    @Shadow
    protected BlockBehaviour.BlockStateBase.Cache cache;

    @Unique
    private BlockState self() {
        return (BlockState)this;
    }

    @Inject(at={@At(value="HEAD")}, method={"getCollisionShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/phys/shapes/VoxelShape;"}, cancellable=true)
    private void pfoliage_getCollisionShape(BlockGetter worldIn, BlockPos pos, CallbackInfoReturnable<VoxelShape> ci) {
        if (PassableFoliage.isPassable(this.self())) {
            ci.setReturnValue((Object)Shapes.empty());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getCollisionShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;"}, cancellable=true)
    private void pfoliage_getCollisionShape(BlockGetter worldIn, BlockPos pos, CollisionContext context, CallbackInfoReturnable<VoxelShape> ci) {
        if (PassableFoliage.isPassable(this.self())) {
            Entity entity = null;
            if (context instanceof EntityCollisionContext) {
                entity = ((EntityCollisionContext)context).getEntity();
            }
            if (PassableFoliageCommonConfig.playerOnly && !(entity instanceof Player)) {
                return;
            }
            if (entity instanceof LivingEntity && PassableFoliage.hasLeafWalker((LivingEntity)entity)) {
                if (context.isDescending() || entity.blockPosition().getY() <= pos.getY()) {
                    ci.setReturnValue((Object)Shapes.empty());
                }
                return;
            }
            ci.setReturnValue((Object)Shapes.empty());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getVisualShape"}, cancellable=true)
    private void pfoliage_getVisualShape(BlockGetter p_60772_, BlockPos p_60773_, CollisionContext p_60774_, CallbackInfoReturnable<VoxelShape> ci) {
        if (PassableFoliage.isPassable(this.self())) {
            ci.setReturnValue((Object)Shapes.empty());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isCollisionShapeFullBlock"}, cancellable=true)
    private void pfoliage_isCollisionShapeFullBlock(BlockGetter blockReaderIn, BlockPos blockPosIn, CallbackInfoReturnable<Boolean> ci) {
        if (this.cache == null && PassableFoliage.isPassable(this.self())) {
            ci.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"entityInside"})
    private void pfoliage_entityInside(Level worldIn, BlockPos pos, Entity entityIn, CallbackInfo ci) {
        if (PassableFoliage.isPassable(this.self())) {
            PassableFoliage.onEntityCollidedWithLeaves(worldIn, pos, this.self(), entityIn);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getShadeBrightness"}, cancellable=true)
    private void pfoliage_getShadeBrightness(BlockGetter reader, BlockPos pos, CallbackInfoReturnable<Float> ci) {
        if (PassableFoliage.isPassable(this.self())) {
            PassableFoliage.setSuppressPassableCheck(true);
            boolean full = ((BlockBehaviourAccess)this.self().getBlock()).callIsCollisionShapeFullBlock(this.self(), reader, pos);
            PassableFoliage.setSuppressPassableCheck(false);
            ci.setReturnValue((Object)Float.valueOf(full ? 0.2f : 1.0f));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isSuffocating"}, cancellable=true)
    private void pfoliage_isSuffocating(BlockGetter level, BlockPos pos, CallbackInfoReturnable<Boolean> ci) {
        if (PassableFoliage.isPassable(this.self())) {
            ci.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isViewBlocking"}, cancellable=true)
    private void pfoliage_isViewBlocking(BlockGetter level, BlockPos pos, CallbackInfoReturnable<Boolean> ci) {
        if (PassableFoliageCommonConfig.alwaysNotViewBlocking && PassableFoliage.isPassable(this.self())) {
            ci.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canOcclude"}, cancellable=true)
    private void pfoliage_canOcclude(CallbackInfoReturnable<Boolean> cir) {
        if (PassableFoliage.isPassable(this.self())) {
            cir.setReturnValue((Object)false);
        }
    }
}

