/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.item.upgrade.VehicleStat;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public abstract class Rotorcraft
extends AircraftEntity {
    public Rotorcraft(EntityType<? extends AircraftEntity> entityType, Level world, boolean canExplodeOnCrash) {
        super(entityType, world, canExplodeOnCrash);
    }

    @Override
    public Vector3f getForwardDirection() {
        return new Vector3f(Mth.sin((float)(-this.getYRot() * ((float)Math.PI / 180))), 0.0f, Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))).normalize();
    }

    @Override
    public Vector3f getRightDirection() {
        return new Vector3f(Mth.cos((float)(-this.getYRot() * ((float)Math.PI / 180))), 0.0f, Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)))).normalize();
    }

    @Override
    protected void convertPower(Vec3 direction) {
        Vec3 velocity = this.getDeltaMovement().multiply(1.0, 0.0, 1.0);
        double drag = Math.abs(direction.dot(velocity.normalize()));
        Vec3 newVelocity = velocity.normalize().lerp(direction, (double)this.getProperties().get(VehicleStat.LIFT)).scale(velocity.length() * (drag * (double)this.getProperties().get(VehicleStat.FRICTION) + (1.0 - (double)this.getProperties().get(VehicleStat.FRICTION))));
        this.setDeltaMovement(newVelocity.x, this.getDeltaMovement().y, newVelocity.z);
    }
}

