/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft;

import immersive_aircraft.Main;
import immersive_aircraft.cobalt.registration.Registration;
import immersive_aircraft.entity.AirshipEntity;
import immersive_aircraft.entity.BambooHopperEntity;
import immersive_aircraft.entity.BiplaneEntity;
import immersive_aircraft.entity.CargoAirshipEntity;
import immersive_aircraft.entity.GyrodyneEntity;
import immersive_aircraft.entity.QuadrocopterEntity;
import immersive_aircraft.entity.WarshipEntity;
import immersive_aircraft.entity.bullet.BulletEntity;
import immersive_aircraft.entity.bullet.TinyTNT;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;

public interface Entities {
    public static final Supplier<EntityType<GyrodyneEntity>> GYRODYNE = Entities.register("gyrodyne", EntityType.Builder.of(GyrodyneEntity::new, (MobCategory)MobCategory.MISC).sized(1.3f, 0.6f).clientTrackingRange(12).fireImmune());
    public static final Supplier<EntityType<BiplaneEntity>> BIPLANE = Entities.register("biplane", EntityType.Builder.of(BiplaneEntity::new, (MobCategory)MobCategory.MISC).sized(1.75f, 0.85f).clientTrackingRange(12).fireImmune());
    public static final Supplier<EntityType<AirshipEntity>> AIRSHIP = Entities.register("airship", EntityType.Builder.of(AirshipEntity::new, (MobCategory)MobCategory.MISC).sized(1.5f, 3.0f).clientTrackingRange(12).fireImmune());
    public static final Supplier<EntityType<CargoAirshipEntity>> CARGO_AIRSHIP = Entities.register("cargo_airship", EntityType.Builder.of(CargoAirshipEntity::new, (MobCategory)MobCategory.MISC).sized(1.75f, 3.0f).clientTrackingRange(12).fireImmune());
    public static final Supplier<EntityType<WarshipEntity>> WARSHIP = Entities.register("warship", EntityType.Builder.of(WarshipEntity::new, (MobCategory)MobCategory.MISC).sized(5.0f, 6.5f).clientTrackingRange(16).fireImmune());
    public static final Supplier<EntityType<QuadrocopterEntity>> QUADROCOPTER = Entities.register("quadrocopter", EntityType.Builder.of(QuadrocopterEntity::new, (MobCategory)MobCategory.MISC).sized(1.5f, 0.5f).clientTrackingRange(10).fireImmune());
    public static final Supplier<EntityType<BambooHopperEntity>> BAMBOO_HOPPER = Entities.register("bamboo_hopper", EntityType.Builder.of(BambooHopperEntity::new, (MobCategory)MobCategory.MISC).sized(3.0f, 1.5f).clientTrackingRange(14).fireImmune());
    public static final Supplier<EntityType<BulletEntity>> BULLET = Entities.register("bullet", EntityType.Builder.of(BulletEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(10).updateInterval(10).fireImmune());
    public static final Supplier<EntityType<TinyTNT>> TINY_TNT = Entities.register("tiny_tnt", EntityType.Builder.of(TinyTNT::new, (MobCategory)MobCategory.MISC).sized(0.375f, 0.375f).clientTrackingRange(10).updateInterval(10).fireImmune());

    public static void bootstrap() {
    }

    public static <T extends Entity> Supplier<EntityType<T>> register(String name, EntityType.Builder<T> builder) {
        ResourceLocation id = Main.locate(name);
        return Registration.register(BuiltInRegistries.ENTITY_TYPE, id, () -> builder.build(id.toString()));
    }
}

