/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.registry;

import com.google.common.collect.ImmutableSet;
import gg.moonflower.etched.core.Etched;
import gg.moonflower.etched.core.mixin.StructureTemplatePoolAccessor;
import gg.moonflower.etched.core.registry.EtchedBlocks;
import gg.moonflower.etched.core.registry.EtchedItems;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="etched")
public class EtchedVillagers {
    public static final DeferredRegister<PoiType> POI_REGISTRY = DeferredRegister.create((Registry)BuiltInRegistries.POINT_OF_INTEREST_TYPE, (String)"etched");
    public static final DeferredRegister<VillagerProfession> PROFESSION_REGISTRY = DeferredRegister.create((Registry)BuiltInRegistries.VILLAGER_PROFESSION, (String)"etched");
    public static final DeferredHolder<PoiType, PoiType> BARD_POI = POI_REGISTRY.register("bard", () -> new PoiType((Set)ImmutableSet.builder().addAll((Iterable)Blocks.NOTE_BLOCK.getStateDefinition().getPossibleStates()).build(), 1, 1));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> BARD = PROFESSION_REGISTRY.register("bard", () -> new VillagerProfession("etched:bard", poi -> poi.is(BARD_POI.getId()), poi -> poi.is(BARD_POI.getId()), ImmutableSet.of(), ImmutableSet.of(), null));

    @SubscribeEvent
    public static void onEvent(VillagerTradesEvent event) {
        if (event.getType() != BARD.get()) {
            return;
        }
        Int2ObjectOpenHashMap newTrades = new Int2ObjectOpenHashMap();
        int minTier = event.getTrades().keySet().intStream().min().orElse(1);
        int maxTier = event.getTrades().keySet().intStream().max().orElse(5);
        EtchedVillagers.registerTrades(arg_0 -> EtchedVillagers.lambda$onEvent$5(minTier, maxTier, (Int2ObjectMap)newTrades, arg_0));
        newTrades.forEach((tier, registry) -> ((List)event.getTrades().get(tier.intValue())).addAll(registry));
    }

    private static void registerTrades(Function<Integer, TradeRegistry> context) {
        TradeRegistry tier1 = context.apply(1);
        tier1.add((ItemLike)Items.MUSIC_DISC_13, 8, 1, 4, 20, true);
        tier1.add((ItemLike)Items.MUSIC_DISC_11, 8, 1, 4, 20, true);
        tier1.add((ItemLike)Items.MUSIC_DISC_CAT, 8, 1, 4, 20, true);
        tier1.add((ItemLike)Items.MUSIC_DISC_OTHERSIDE, 8, 1, 4, 20, true);
        tier1.add((ItemLike)Items.NOTE_BLOCK, 1, 2, 16, 2, true);
        tier1.add((ItemLike)EtchedItems.MUSIC_LABEL.asItem(), 4, 2, 16, 1, false);
        TradeRegistry tier2 = context.apply(2);
        tier2.add((ItemLike)EtchedItems.BLANK_MUSIC_DISC.asItem(), 28, 2, 12, 15, false);
        tier2.add((ItemLike)EtchedBlocks.ETCHING_TABLE.asItem(), 32, 1, 8, 15, false);
        TradeRegistry tier3 = context.apply(3);
        tier3.add((ItemLike)Blocks.CLAY, 6, 1, 16, 2, false);
        tier3.add((ItemLike)Blocks.HAY_BLOCK, 12, 1, 8, 2, false);
        tier3.add((ItemLike)Blocks.WHITE_WOOL, 8, 1, 32, 4, false);
        tier3.add((ItemLike)Blocks.BONE_BLOCK, 24, 1, 8, 4, false);
        tier3.add((ItemLike)Blocks.PACKED_ICE, 36, 1, 4, 8, false);
        tier3.add((ItemLike)Blocks.GOLD_BLOCK, 48, 1, 2, 10, false);
        TradeRegistry tier4 = context.apply(4);
        tier3.add((ItemLike)Items.JUKEBOX, 26, 1, 4, 30, false);
        tier4.add((ItemLike)EtchedItems.JUKEBOX_MINECART.asItem(), 28, 1, 4, 30, false);
        tier4.add((ItemLike)EtchedBlocks.ALBUM_JUKEBOX.asItem(), 30, 1, 4, 30, false);
        TradeRegistry tier5 = context.apply(5);
        tier5.add((ItemLike)Items.DIAMOND, 8, 1, 8, 40, true);
        tier5.add((ItemLike)Items.AMETHYST_SHARD, 1, 8, 10, 40, true);
        BuiltInRegistries.ITEM.getTag(ItemTags.CREEPER_DROP_MUSIC_DISCS).ifPresent(tag -> tag.stream().forEach(item -> tier5.add((ItemLike)item.value(), 10, 1, 4, 40, true)));
    }

    @SubscribeEvent
    public static void onEvent(ServerAboutToStartEvent event) {
        RegistryAccess.Frozen access = event.getServer().registryAccess();
        Optional templateRegistryOptional = access.registry(Registries.TEMPLATE_POOL);
        Optional processorListRegistyOptional = access.registry(Registries.PROCESSOR_LIST);
        if (templateRegistryOptional.isEmpty() || processorListRegistyOptional.isEmpty()) {
            return;
        }
        Registry templatePools = (Registry)templateRegistryOptional.get();
        Registry processorLists = (Registry)processorListRegistyOptional.get();
        EtchedVillagers.createVillagePiece((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, "plains", "bard_house", 1, 2, (ResourceKey<StructureProcessorList>)ProcessorLists.MOSSIFY_10_PERCENT, (ResourceKey<StructureProcessorList>)ProcessorLists.ZOMBIE_PLAINS);
        EtchedVillagers.createVillagePiece((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, "desert", "bard_house", 1, 2, (ResourceKey<StructureProcessorList>)ProcessorLists.ZOMBIE_DESERT);
        EtchedVillagers.createVillagePiece((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, "savanna", "bard_house", 1, 4, (ResourceKey<StructureProcessorList>)ProcessorLists.ZOMBIE_SAVANNA);
        EtchedVillagers.createVillagePiece((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, "snowy", "bard_house", 1, 4, (ResourceKey<StructureProcessorList>)ProcessorLists.ZOMBIE_SNOWY);
        EtchedVillagers.createVillagePiece((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, "taiga", "bard_house", 1, 4, (ResourceKey<StructureProcessorList>)ProcessorLists.MOSSIFY_10_PERCENT, (ResourceKey<StructureProcessorList>)ProcessorLists.ZOMBIE_TAIGA);
    }

    private static void createVillagePiece(Registry<StructureTemplatePool> templatePools, Registry<StructureProcessorList> processorLists, String village, String name, int houseId, int weight, ResourceKey<StructureProcessorList> zombieProcessor) {
        EtchedVillagers.createVillagePiece(templatePools, processorLists, village, name, houseId, weight, (ResourceKey<StructureProcessorList>)ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)name)), zombieProcessor);
    }

    private static void createVillagePiece(Registry<StructureTemplatePool> templatePools, Registry<StructureProcessorList> processorLists, String village, String name, int houseId, int weight, ResourceKey<StructureProcessorList> normalProcessor, ResourceKey<StructureProcessorList> zombieProcessor) {
        EtchedVillagers.addToPool((StructureTemplatePool)templatePools.get(ResourceLocation.withDefaultNamespace((String)("village/" + village + "/houses"))), Etched.etchedPath("village/" + village + "/houses/" + village + "_" + name + "_" + houseId), (Holder<StructureProcessorList>)((Holder)processorLists.getHolder(normalProcessor).orElse(null)), weight);
        EtchedVillagers.addToPool((StructureTemplatePool)templatePools.get(ResourceLocation.withDefaultNamespace((String)("village/" + village + "/zombie/houses"))), Etched.etchedPath("village/" + village + "/houses/" + village + "_" + name + "_" + houseId), (Holder<StructureProcessorList>)((Holder)processorLists.getHolder(zombieProcessor).orElse(null)), weight);
    }

    private static void addToPool(@Nullable StructureTemplatePool pool, ResourceLocation pieceId, @Nullable Holder<StructureProcessorList> processorList, int weight) {
        if (pool == null || processorList == null) {
            return;
        }
        StructurePoolElement piece = (StructurePoolElement)StructurePoolElement.legacy((String)pieceId.toString(), processorList).apply(StructureTemplatePool.Projection.RIGID);
        ObjectArrayList<StructurePoolElement> templates = ((StructureTemplatePoolAccessor)pool).getTemplates();
        if (templates == null) {
            return;
        }
        for (int i = 0; i < weight; ++i) {
            templates.add(piece);
        }
    }

    private static /* synthetic */ TradeRegistry lambda$onEvent$5(int minTier, int maxTier, Int2ObjectMap newTrades, Integer tier) {
        Validate.inclusiveBetween((long)minTier, (long)maxTier, (long)tier.intValue(), (String)("Tier must be between " + minTier + " and " + maxTier));
        return (TradeRegistry)newTrades.computeIfAbsent((Object)tier, key -> new TradeRegistry());
    }

    private static class TradeRegistry
    implements List<VillagerTrades.ItemListing> {
        private final List<VillagerTrades.ItemListing> trades = NonNullList.create();

        @Override
        public int size() {
            return this.trades.size();
        }

        @Override
        public boolean isEmpty() {
            return this.trades.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.trades.contains(o);
        }

        @Override
        @NotNull
        public Iterator<VillagerTrades.ItemListing> iterator() {
            return this.trades.iterator();
        }

        @Override
        @NotNull
        public Object[] toArray() {
            return this.trades.toArray();
        }

        @Override
        @NotNull
        public <T> T[] toArray(@NotNull T[] a) {
            return this.trades.toArray(a);
        }

        @Override
        public boolean add(VillagerTrades.ItemListing listing) {
            return this.trades.add(listing);
        }

        @Override
        public boolean remove(Object o) {
            return this.trades.remove(o);
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> c) {
            return this.trades.containsAll(c);
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends VillagerTrades.ItemListing> c) {
            return this.trades.addAll(c);
        }

        @Override
        public boolean addAll(int index, @NotNull Collection<? extends VillagerTrades.ItemListing> c) {
            return this.trades.addAll(index, c);
        }

        @Override
        public boolean removeAll(@NotNull Collection<?> c) {
            return this.trades.removeAll(c);
        }

        @Override
        public boolean retainAll(@NotNull Collection<?> c) {
            return this.trades.retainAll(c);
        }

        @Override
        public void clear() {
            this.trades.clear();
        }

        @Override
        public VillagerTrades.ItemListing get(int index) {
            return this.trades.get(index);
        }

        @Override
        public VillagerTrades.ItemListing set(int index, VillagerTrades.ItemListing element) {
            return this.trades.set(index, element);
        }

        @Override
        public void add(int index, VillagerTrades.ItemListing element) {
            this.trades.add(index, element);
        }

        @Override
        public VillagerTrades.ItemListing remove(int index) {
            return this.trades.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.trades.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.trades.lastIndexOf(o);
        }

        @Override
        @NotNull
        public ListIterator<VillagerTrades.ItemListing> listIterator() {
            return this.trades.listIterator();
        }

        @Override
        @NotNull
        public ListIterator<VillagerTrades.ItemListing> listIterator(int index) {
            return this.trades.listIterator(index);
        }

        @Override
        @NotNull
        public List<VillagerTrades.ItemListing> subList(int fromIndex, int toIndex) {
            return this.trades.subList(fromIndex, toIndex);
        }

        public void add(ItemLike item, int emeralds, int itemCount, int maxUses, int xpGain, boolean sellToVillager) {
            this.add(new ItemTrade(item, emeralds, itemCount, maxUses, xpGain, 0.05f, sellToVillager));
        }

        public void add(ItemLike item, int emeralds, int itemCount, int maxUses, int xpGain, float priceMultiplier, boolean sellToVillager) {
            this.add(new ItemTrade(item, emeralds, itemCount, maxUses, xpGain, priceMultiplier, sellToVillager));
        }
    }

    private static class ItemTrade
    implements VillagerTrades.ItemListing {
        private final ItemLike item;
        private final int emeralds;
        private final int itemCount;
        private final int maxUses;
        private final int xpGain;
        private final float priceMultiplier;
        private final boolean sellToVillager;

        private ItemTrade(ItemLike Item2, int emeralds, int itemCount, int maxUses, int xpGain, float priceMultiplier, boolean sellToVillager) {
            this.item = Item2;
            this.emeralds = emeralds;
            this.itemCount = itemCount;
            this.maxUses = maxUses;
            this.xpGain = xpGain;
            this.priceMultiplier = priceMultiplier;
            this.sellToVillager = sellToVillager;
        }

        public MerchantOffer getOffer(Entity entity, RandomSource random) {
            if (this.sellToVillager) {
                ItemStack item = new ItemStack((ItemLike)Items.EMERALD, this.emeralds);
                return new MerchantOffer(new ItemCost(this.item, this.itemCount), item, this.maxUses, this.xpGain, this.priceMultiplier);
            }
            ItemStack item = new ItemStack(this.item, this.itemCount);
            return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, this.emeralds), item, this.maxUses, this.xpGain, this.priceMultiplier);
        }
    }
}

