/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.mixin.client.sound;

import com.mojang.blaze3d.audio.Channel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Channel.class})
public class ChannelMixin {
    @Unique
    private final AtomicBoolean etched$loaded = new AtomicBoolean(false);
    @Unique
    private final AtomicBoolean etched$stopped = new AtomicBoolean(false);

    @Inject(method={"stop"}, at={@At(value="HEAD")})
    public void stop(CallbackInfo ci) {
        if (!this.etched$loaded.get()) {
            this.etched$stopped.set(true);
        }
    }

    @Inject(method={"play"}, at={@At(value="HEAD")}, cancellable=true)
    public void play(CallbackInfo ci) {
        if (this.etched$stopped.get()) {
            this.etched$stopped.set(false);
            ci.cancel();
        }
    }

    @Inject(method={"stopped"}, at={@At(value="TAIL")}, cancellable=true)
    public void stopped(CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue() && this.etched$stopped.get()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"attachStaticBuffer"}, at={@At(value="HEAD")})
    public void attachStaticBuffer(CallbackInfo ci) {
        this.etched$loaded.set(true);
    }

    @Inject(method={"attachBufferStream"}, at={@At(value="HEAD")})
    public void attachBufferStream(CallbackInfo ci) {
        this.etched$loaded.set(true);
    }
}

