/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core;

import gg.moonflower.etched.common.component.AlbumCoverComponent;
import gg.moonflower.etched.core.registry.EtchedBlocks;
import gg.moonflower.etched.core.registry.EtchedComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.GrindstoneEvent;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;

@EventBusSubscriber(modid="etched")
public class EtchedEvents {
    @SubscribeEvent
    public static void onGrindstoneChange(GrindstoneEvent.OnPlaceItem event) {
        ItemStack top = event.getTopItem();
        ItemStack bottom = event.getBottomItem();
        if (top.isEmpty() == bottom.isEmpty()) {
            return;
        }
        ItemStack stack = top.isEmpty() ? bottom : top;
        AlbumCoverComponent albumCover = (AlbumCoverComponent)stack.get(EtchedComponents.ALBUM_COVER);
        if (albumCover != null && !albumCover.getCoverStack().isEmpty()) {
            ItemStack result = stack.copyWithCount(1);
            result.set(EtchedComponents.ALBUM_COVER, (Object)albumCover.toBuilder().setCoverStack(ItemStack.EMPTY).build());
            event.setOutput(result);
        }
    }

    @SubscribeEvent
    public static void onItemChangedDimension(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity) {
            ItemEntity entity2 = (ItemEntity)entity;
            if (event.getDimension() == Level.NETHER) {
                ItemStack oldStack = entity2.getItem();
                if (oldStack.getItem() != ((Block)EtchedBlocks.RADIO.get()).asItem()) {
                    return;
                }
                ItemStack newStack = new ItemStack((ItemLike)EtchedBlocks.PORTAL_RADIO_ITEM.get(), oldStack.getCount());
                newStack.applyComponents(oldStack.getComponents());
                entity2.setItem(newStack);
            }
        }
    }
}

