/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.item;

import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public interface ContainerItem {
    public static int findSlotMatchingItem(Inventory inventory, ItemStack stack) {
        for (int i = 0; i < inventory.items.size(); ++i) {
            ItemStack slotStack = (ItemStack)inventory.items.get(i);
            if (slotStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slotStack)) continue;
            return i;
        }
        return -1;
    }

    default public InteractionResultHolder<ItemStack> use(Item item, Level level, Player player, InteractionHand hand) {
        final ItemStack stack = player.getItemInHand(hand);
        final int index = ContainerItem.findSlotMatchingItem(player.getInventory(), stack);
        if (index == -1) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (!level.isClientSide()) {
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return stack.getHoverName();
                }

                public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
                    return ContainerItem.this.constructMenu(containerId, inventory, player, index);
                }
            });
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public AbstractContainerMenu constructMenu(int var1, Inventory var2, Player var3, int var4);
}

