/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.item;

import gg.moonflower.etched.common.component.AlbumCoverComponent;
import gg.moonflower.etched.common.item.ContainerItem;
import gg.moonflower.etched.common.menu.AlbumCoverMenu;
import gg.moonflower.etched.core.Etched;
import gg.moonflower.etched.core.registry.EtchedComponents;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;

public class AlbumCoverItem
extends Item
implements ContainerItem {
    public AlbumCoverItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!((Boolean)Etched.SERVER_CONFIG.useAlbumCoverMenu.get()).booleanValue()) {
            if (player.isSecondaryUseActive()) {
                if (AlbumCoverItem.dropContents(stack, player)) {
                    this.playDropContentsSound((Entity)player);
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                    return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
                }
                return InteractionResultHolder.pass((Object)stack);
            }
            return InteractionResultHolder.fail((Object)stack);
        }
        return this.use(this, level, player, hand);
    }

    @Override
    public AbstractContainerMenu constructMenu(int containerId, Inventory inventory, Player player, int index) {
        return new AlbumCoverMenu(containerId, inventory, index);
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction clickAction, Player player) {
        if (((Boolean)Etched.SERVER_CONFIG.useAlbumCoverMenu.get()).booleanValue()) {
            return false;
        }
        if (clickAction != ClickAction.SECONDARY) {
            return false;
        }
        AlbumCoverComponent.Builder albumCover = AlbumCoverComponent.builder(stack);
        ItemStack clickItem = slot.getItem();
        if (clickItem.isEmpty()) {
            ItemStack removed = albumCover.extract(slot.container);
            if (!removed.isEmpty()) {
                this.playRemoveOneSound((Entity)player);
                ItemStack remaining = slot.safeInsert(removed);
                if (!remaining.isEmpty()) {
                    albumCover.insert(remaining);
                    return true;
                }
            }
        } else {
            ItemStack remaining;
            int count = slot.getItem().getCount();
            if (count != (remaining = albumCover.insert(slot.getItem())).getCount()) {
                this.playInsertSound((Entity)player);
                stack.set(EtchedComponents.ALBUM_COVER, (Object)albumCover.build());
                slot.safeTake(count, count - remaining.getCount(), player);
                return true;
            }
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack clickItem, Slot slot, ClickAction clickAction, Player player, SlotAccess access) {
        if (((Boolean)Etched.SERVER_CONFIG.useAlbumCoverMenu.get()).booleanValue()) {
            return false;
        }
        if (clickAction != ClickAction.SECONDARY) {
            return false;
        }
        if (!slot.allowModification(player)) {
            return false;
        }
        AlbumCoverComponent.Builder albumCover = AlbumCoverComponent.builder(stack);
        if (clickItem.isEmpty()) {
            ItemStack removed = albumCover.extract(slot.container);
            if (!removed.isEmpty()) {
                this.playRemoveOneSound((Entity)player);
                access.set(removed);
                return true;
            }
        } else {
            ItemStack remaining = albumCover.insert(clickItem);
            if (clickItem.getCount() != remaining.getCount()) {
                this.playInsertSound((Entity)player);
                access.set(remaining);
                stack.set(EtchedComponents.ALBUM_COVER, (Object)albumCover.build());
                return true;
            }
        }
        return false;
    }

    public void onDestroyed(ItemEntity itemEntity) {
        AlbumCoverComponent albumCover = (AlbumCoverComponent)itemEntity.getItem().get(EtchedComponents.ALBUM_COVER);
        if (albumCover != null) {
            List<ItemStack> items = albumCover.getItems();
            AlbumCoverComponent.Builder builder = albumCover.toBuilder();
            builder.clearContent();
            itemEntity.getItem().set(EtchedComponents.ALBUM_COVER, (Object)builder.build());
            ItemUtils.onContainerDestroyed((ItemEntity)itemEntity, items);
        }
    }

    private void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private static boolean dropContents(ItemStack stack, Player player) {
        AlbumCoverComponent albumCover = (AlbumCoverComponent)stack.get(EtchedComponents.ALBUM_COVER);
        if (albumCover != null && !albumCover.isEmpty()) {
            List<ItemStack> items = albumCover.getItems();
            AlbumCoverComponent.Builder builder = albumCover.toBuilder();
            builder.clearContent();
            stack.set(EtchedComponents.ALBUM_COVER, (Object)builder.build());
            if (player instanceof ServerPlayer) {
                items.forEach(item -> player.drop(item, true));
            }
            return true;
        }
        return false;
    }

    public boolean canGrindstoneRepair(ItemStack stack) {
        AlbumCoverComponent albumCover = (AlbumCoverComponent)stack.get(EtchedComponents.ALBUM_COVER);
        return albumCover != null && albumCover.getCoverStack() != null;
    }
}

