/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.sound.source;

import com.mojang.util.UndashedUuid;
import gg.moonflower.etched.api.sound.download.SoundDownloadSource;
import gg.moonflower.etched.api.util.AsyncInputStream;
import gg.moonflower.etched.api.util.DownloadProgressListener;
import gg.moonflower.etched.api.util.ProgressTrackingInputStream;
import gg.moonflower.etched.client.sound.SoundCache;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public interface AudioSource {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final long MAX_SIZE = 0x6400000L;

    public static Map<String, String> getDownloadHeaders() {
        Map<String, String> map = SoundDownloadSource.getDownloadHeaders();
        User user = Minecraft.getInstance().getUser();
        map.put("X-Minecraft-Username", user.getName());
        map.put("X-Minecraft-UUID", UndashedUuid.toString((UUID)user.getProfileId()));
        return map;
    }

    public static AsyncInputStream.InputStreamSupplier downloadTo(URL url, boolean temporary, @Nullable DownloadProgressListener progressListener, AudioFileType type) {
        Path path;
        try {
            path = SoundCache.resolveFilePath(url.toString(), temporary);
        }
        catch (Throwable t) {
            throw new CompletionException(t);
        }
        String key = url.toString();
        SoundCache.CacheMetadata metadata = SoundCache.getMetadata(key);
        if (Files.exists(path, new LinkOption[0]) && metadata != null && metadata.isFresh() && !metadata.noCache()) {
            return () -> Files.newInputStream(path, new OpenOption[0]);
        }
        if (progressListener != null) {
            progressListener.progressStartRequest((Component)Component.translatable((String)"resourcepack.requesting"));
        }
        try {
            long expiration;
            String ageHeader;
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            AudioSource.getDownloadHeaders().forEach(connection::setRequestProperty);
            int response = connection.getResponseCode();
            if (response != 200) {
                if (Files.exists(path, new LinkOption[0]) && metadata != null && (metadata.isFresh() || metadata.staleIfError())) {
                    return () -> Files.newInputStream(path, new OpenOption[0]);
                }
                throw new IOException("Failed to connect to " + String.valueOf(url) + ": " + response + ". " + connection.getResponseMessage());
            }
            long contentLength = connection.getContentLengthLong();
            long cacheTime = Long.MAX_VALUE;
            int cachePriority = 0;
            boolean noCache = false;
            boolean staleIfError = false;
            boolean noStore = false;
            String cacheControl = connection.getHeaderField("Cache-Control");
            if (cacheControl != null) {
                String[] parts;
                for (String part : parts = cacheControl.split(",")) {
                    try {
                        String[] entry = part.split("=");
                        String name = entry[0].trim();
                        String value = entry.length > 1 ? entry[1].trim() : null;
                        switch (name) {
                            case "max-age": {
                                if (cachePriority > 0) break;
                                try {
                                    cacheTime = Integer.parseInt(Objects.requireNonNull(value));
                                }
                                catch (NumberFormatException e) {
                                    LOGGER.error("Invalid max-age: {}", (Object)value);
                                }
                                break;
                            }
                            case "s-maxage": {
                                cachePriority = 1;
                                try {
                                    cacheTime = Integer.parseInt(Objects.requireNonNull(value));
                                }
                                catch (NumberFormatException e) {
                                    LOGGER.error("Invalid s-maxage: {}", (Object)value);
                                }
                                break;
                            }
                            case "no-cache": {
                                noCache = true;
                                break;
                            }
                            case "no-store": {
                                noStore = true;
                                break;
                            }
                            case "stale-if-error": {
                                staleIfError = true;
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Invalid response header: {}", (Object)part, (Object)e);
                    }
                }
            }
            if ((ageHeader = connection.getHeaderField("Age")) != null) {
                try {
                    cacheTime -= (long)Integer.parseInt(ageHeader);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Invalid Age: " + ageHeader);
                }
            }
            if (contentLength < 0L || cacheTime <= 0L || noStore) {
                if (contentLength > 0L && type.isFile()) {
                    LOGGER.debug("No-cache file found!");
                    cacheTime = Long.MAX_VALUE;
                } else {
                    Files.deleteIfExists(path);
                    SoundCache.updateCacheMetadata(key, null);
                    if (!type.isStream()) {
                        throw new IOException("The provided URL is a stream, but that is not supported");
                    }
                    return () -> new AsyncInputStream(url::openStream, 8192, 8, Util.nonCriticalIoPool());
                }
            }
            long l = expiration = cacheTime == Long.MAX_VALUE ? cacheTime : System.currentTimeMillis() / 1000L + cacheTime;
            if (Files.exists(path, new LinkOption[0]) && metadata != null && metadata.isFresh()) {
                SoundCache.updateCacheMetadata(key, new SoundCache.CacheMetadata(expiration, noCache, staleIfError));
                return () -> Files.newInputStream(path, new OpenOption[0]);
            }
            if (!type.isFile()) {
                throw new IOException("The provided URL is a file, but that is not supported");
            }
            if (contentLength > 0x6400000L) {
                throw new IOException("File size is bigger than maximum allowed (file is " + contentLength + ", limit is 104857600)");
            }
            try (ProgressTrackingInputStream stream = new ProgressTrackingInputStream(connection.getInputStream(), contentLength, progressListener){

                @Override
                public int read() throws IOException {
                    int value = super.read();
                    if ((long)this.getRead() > 0x6400000L) {
                        throw new IOException("File size was bigger than maximum allowed (got >= " + this.getRead() + ", limit was 104857600)");
                    }
                    return value;
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    int value = super.read(b, off, len);
                    if ((long)this.getRead() > 0x6400000L) {
                        throw new IOException("File size was bigger than maximum allowed (got >= " + this.getRead() + ", limit was 104857600)");
                    }
                    return value;
                }
            };){
                SoundCache.updateCache(path, key, stream, new SoundCache.CacheMetadata(expiration, noCache, staleIfError));
            }
        }
        catch (Throwable e) {
            throw new CompletionException(e);
        }
        return () -> Files.newInputStream(path, new OpenOption[0]);
    }

    public CompletableFuture<InputStream> openStream();

    public static enum AudioFileType {
        FILE(true, false),
        STREAM(false, true),
        BOTH(true, true);

        private final boolean file;
        private final boolean stream;

        private AudioFileType(boolean file, boolean stream) {
            this.file = file;
            this.stream = stream;
        }

        public boolean isFile() {
            return this.file;
        }

        public boolean isStream() {
            return this.stream;
        }
    }
}

