/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.sound;

import gg.moonflower.etched.api.sound.SoundStopListener;
import gg.moonflower.etched.api.sound.TickableStopListeningSound;
import gg.moonflower.etched.api.sound.WrappedSoundInstance;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.client.sounds.SoundBufferLibrary;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.Nullable;

public class StopListeningSound
implements SoundInstance,
SoundStopListener,
WrappedSoundInstance {
    private final SoundInstance source;
    private final SoundStopListener listener;
    private boolean ignoringEvents;

    StopListeningSound(SoundInstance source, SoundStopListener listener) {
        this.source = source;
        this.listener = listener;
        this.ignoringEvents = false;
    }

    public static StopListeningSound create(SoundInstance source, SoundStopListener listener) {
        return source instanceof TickableSoundInstance ? new TickableStopListeningSound((TickableSoundInstance)source, listener) : new StopListeningSound(source, listener);
    }

    public void stopListening() {
        this.ignoringEvents = true;
    }

    @Override
    public SoundInstance getParent() {
        return this.source;
    }

    public ResourceLocation getLocation() {
        return this.source.getLocation();
    }

    @Nullable
    public WeighedSoundEvents resolve(SoundManager soundManager) {
        return this.source.resolve(soundManager);
    }

    public Sound getSound() {
        return this.source.getSound();
    }

    public SoundSource getSource() {
        return this.source.getSource();
    }

    public boolean isLooping() {
        return this.source.isLooping();
    }

    public boolean isRelative() {
        return this.source.isRelative();
    }

    public int getDelay() {
        return this.source.getDelay();
    }

    public float getVolume() {
        return this.source.getVolume();
    }

    public float getPitch() {
        return this.source.getPitch();
    }

    public double getX() {
        return this.source.getX();
    }

    public double getY() {
        return this.source.getY();
    }

    public double getZ() {
        return this.source.getZ();
    }

    public SoundInstance.Attenuation getAttenuation() {
        return this.source.getAttenuation();
    }

    public boolean canStartSilent() {
        return this.source.canStartSilent();
    }

    public boolean canPlaySound() {
        return this.source.canPlaySound();
    }

    public CompletableFuture<AudioStream> getStream(SoundBufferLibrary soundBuffers, Sound sound, boolean looping) {
        return this.source.getStream(soundBuffers, sound, looping);
    }

    @Override
    public void onStop() {
        if (!this.ignoringEvents) {
            this.listener.onStop();
        }
    }
}

