/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.support.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.common.support.render.AbstractFluidRenderer;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidStackFluidRenderer
extends AbstractFluidRenderer {
    private final Map<FluidResource, FluidStack> stackCache = new HashMap<FluidResource, FluidStack>();

    private FluidStack getFluidStackFromCache(FluidResource fluidResource) {
        if (this.stackCache.size() > 1000) {
            this.stackCache.clear();
        }
        return this.stackCache.computeIfAbsent(fluidResource, fluid -> new FluidStack(BuiltInRegistries.FLUID.wrapAsHolder((Object)fluid.fluid()), 1000, fluid.components()));
    }

    @Override
    public void render(PoseStack poseStack, int x, int y, FluidResource fluidResource) {
        FluidStack stack = this.getFluidStackFromCache(fluidResource);
        Fluid fluid = fluidResource.fluid();
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        int packedRgb = renderProperties.getTintColor(stack);
        TextureAtlasSprite sprite = this.getStillFluidSprite(renderProperties, stack);
        this.render(poseStack, x, y, packedRgb, sprite);
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource renderTypeBuffer, int light, FluidResource fluidResource) {
        FluidStack stack = this.getFluidStackFromCache(fluidResource);
        Fluid fluid = fluidResource.fluid();
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        int packedRgb = renderProperties.getTintColor(stack);
        TextureAtlasSprite sprite = this.getStillFluidSprite(renderProperties, stack);
        this.render(poseStack, renderTypeBuffer, light, packedRgb, sprite);
    }

    @Override
    public Component getDisplayName(FluidResource fluidResource) {
        return fluidResource.fluid().getFluidType().getDescription();
    }

    private TextureAtlasSprite getStillFluidSprite(IClientFluidTypeExtensions renderProperties, FluidStack fluidStack) {
        Minecraft minecraft = Minecraft.getInstance();
        ResourceLocation fluidStill = renderProperties.getStillTexture(fluidStack);
        return (TextureAtlasSprite)minecraft.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidStill);
    }

    @Override
    public List<Component> getTooltip(FluidResource fluidResource) {
        return Collections.singletonList(this.getFluidStackFromCache(fluidResource).getHoverName());
    }
}

