/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.diskdrive;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.refinedmods.refinedstorage.common.storage.Disk;
import com.refinedmods.refinedstorage.common.storage.diskdrive.AbstractDiskDriveBlockEntity;
import com.refinedmods.refinedstorage.common.storage.diskdrive.DiskDriveBlock;
import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import com.refinedmods.refinedstorage.common.support.render.AbstractDiskLedBlockEntityRenderer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractDiskDriveBlockEntityRenderer<T extends AbstractDiskDriveBlockEntity>
extends AbstractDiskLedBlockEntityRenderer<T> {
    private final RenderType renderType;

    protected AbstractDiskDriveBlockEntityRenderer(RenderType renderType) {
        this.renderType = renderType;
    }

    @Nullable
    protected abstract Disk[] getDisks(T var1);

    public void render(T entity, float tickDelta, PoseStack poseStack, MultiBufferSource vertexConsumers, int light, int overlay) {
        Level level = entity.getLevel();
        if (level == null) {
            return;
        }
        BlockState blockState = level.getBlockState(entity.getBlockPos());
        Block block = blockState.getBlock();
        if (!(block instanceof DiskDriveBlock)) {
            return;
        }
        DiskDriveBlock diskDriveBlock = (DiskDriveBlock)block;
        BiDirection direction = (BiDirection)((Object)diskDriveBlock.getDirection(blockState));
        if (direction == null) {
            return;
        }
        Disk[] disks = this.getDisks(entity);
        if (disks != null) {
            AbstractDiskDriveBlockEntityRenderer.rotate(poseStack, direction);
            this.renderDiskLeds(poseStack, disks, vertexConsumers.getBuffer(this.renderType));
            AbstractDiskDriveBlockEntityRenderer.postRotate(poseStack);
        }
    }

    private void renderDiskLeds(PoseStack poseStack, Disk[] disks, VertexConsumer vertexConsumer) {
        int i = 0;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 2; ++x) {
                Disk disk = disks[i++];
                this.renderLed(poseStack, vertexConsumer, 10 - x * 7, 12 - y * 3, -1, disk, Direction.SOUTH);
            }
        }
    }
}

