/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid;

import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.network.impl.energy.EnergyStorageImpl;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.security.SecurityHelper;
import com.refinedmods.refinedstorage.common.api.support.energy.AbstractNetworkEnergyItem;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemContext;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.grid.WirelessGrid;
import com.refinedmods.refinedstorage.common.grid.WirelessGridExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.security.BuiltinPermission;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class WirelessGridItem
extends AbstractNetworkEnergyItem {
    private final boolean creative;

    public WirelessGridItem(boolean creative) {
        super(new Item.Properties().stacksTo(1), RefinedStorageApi.INSTANCE.getEnergyItemHelper(), RefinedStorageApi.INSTANCE.getNetworkItemHelper());
        this.creative = creative;
    }

    public EnergyStorage createEnergyStorage(ItemStack stack) {
        EnergyStorageImpl energyStorage = new EnergyStorageImpl(Platform.INSTANCE.getConfig().getWirelessGrid().getEnergyCapacity());
        return RefinedStorageApi.INSTANCE.asItemEnergyStorage(energyStorage, stack);
    }

    @Override
    protected void use(@Nullable Component name, ServerPlayer player, SlotReference slotReference, NetworkItemContext context) {
        boolean isAllowed = context.resolveNetwork().map(network -> SecurityHelper.isAllowed(player, (Permission)BuiltinPermission.OPEN, network)).orElse(true);
        if (!isAllowed) {
            RefinedStorageApi.INSTANCE.sendNoPermissionToOpenMessage(player, (Component)ContentNames.WIRELESS_GRID);
            return;
        }
        WirelessGrid grid = new WirelessGrid(context);
        Component correctedName = (Component)Objects.requireNonNullElse(name, this.creative ? ContentNames.CREATIVE_WIRELESS_GRID : ContentNames.WIRELESS_GRID);
        WirelessGridExtendedMenuProvider provider = new WirelessGridExtendedMenuProvider(correctedName, grid, slotReference);
        Platform.INSTANCE.getMenuOpener().openMenu(player, provider);
    }
}

