/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.patterngrid;

import com.mojang.serialization.Codec;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.CraftingPatternGridRenderer;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridRenderer;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.ProcessingPatternGridRenderer;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.SmithingTablePatternGridRenderer;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.StonecutterPatternGridRenderer;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public enum PatternType implements StringRepresentable
{
    CRAFTING(Items.CRAFTING_TABLE.getDefaultInstance(), "crafting"),
    PROCESSING(Items.FURNACE.getDefaultInstance(), "processing"),
    STONECUTTER(Items.STONECUTTER.getDefaultInstance(), "stonecutter"),
    SMITHING_TABLE(Items.SMITHING_TABLE.getDefaultInstance(), "smithing_table");

    public static final Codec<PatternType> CODEC;
    private final ItemStack stack;
    private final String name;
    private final Component translatedName;

    private PatternType(ItemStack stack, String name) {
        this.stack = stack;
        this.name = name;
        this.translatedName = IdentifierUtil.createTranslation("misc", "pattern." + name);
    }

    ItemStack getStack() {
        return this.stack;
    }

    Component getTranslatedName() {
        return this.translatedName;
    }

    PatternGridRenderer createRenderer(PatternGridContainerMenu menu, int leftPos, int topPos, int x, int y) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new CraftingPatternGridRenderer(menu, leftPos, x, y);
            case 1 -> new ProcessingPatternGridRenderer(menu, leftPos, topPos, x, y);
            case 2 -> new StonecutterPatternGridRenderer(menu, leftPos, x, y);
            case 3 -> new SmithingTablePatternGridRenderer(menu, leftPos, topPos, x, y);
        };
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromValues(PatternType::values);
    }
}

