/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager;

import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerSearchMode;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

class SearchModeSideButtonWidget
extends AbstractSideButtonWidget {
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation("gui", "autocrafter_manager.search_mode");
    private static final List<MutableComponent> SUBTEXT_ALL = List.of(IdentifierUtil.createTranslation("gui", "autocrafter_manager.search_mode.all").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_PATTERN_INPUTS = List.of(IdentifierUtil.createTranslation("gui", "autocrafter_manager.search_mode.pattern_inputs").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_PATTERN_OUTPUTS = List.of(IdentifierUtil.createTranslation("gui", "autocrafter_manager.search_mode.pattern_outputs").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_AUTOCRAFTER_NAMES = List.of(IdentifierUtil.createTranslation("gui", "autocrafter_manager.search_mode.autocrafter_names").withStyle(ChatFormatting.GRAY));
    private static final ResourceLocation SPRITE_ALL = IdentifierUtil.createIdentifier("widget/side_button/autocrafter_manager/search_mode/all");
    private static final ResourceLocation SPRITE_PATTERN_INPUTS = IdentifierUtil.createIdentifier("widget/side_button/autocrafter_manager/search_mode/pattern_inputs");
    private static final ResourceLocation SPRITE_PATTERN_OUTPUTS = IdentifierUtil.createIdentifier("widget/side_button/autocrafter_manager/search_mode/pattern_outputs");
    private static final ResourceLocation SPRITE_AUTOCRAFTER_NAMES = IdentifierUtil.createIdentifier("widget/side_button/autocrafter_manager/search_mode/autocrafter_names");
    private final AutocrafterManagerContainerMenu containerMenu;
    private final Supplier<Component> helpTextSupplier;

    SearchModeSideButtonWidget(AutocrafterManagerContainerMenu containerMenu, Supplier<Component> helpTextSupplier) {
        super(SearchModeSideButtonWidget.createPressAction(containerMenu));
        this.containerMenu = containerMenu;
        this.helpTextSupplier = helpTextSupplier;
    }

    private static Button.OnPress createPressAction(AutocrafterManagerContainerMenu containerMenu) {
        return btn -> containerMenu.setSearchMode(containerMenu.getSearchMode().toggle());
    }

    @Override
    protected ResourceLocation getSprite() {
        return switch (this.containerMenu.getSearchMode()) {
            default -> throw new MatchException(null, null);
            case AutocrafterManagerSearchMode.ALL -> SPRITE_ALL;
            case AutocrafterManagerSearchMode.PATTERN_INPUTS -> SPRITE_PATTERN_INPUTS;
            case AutocrafterManagerSearchMode.PATTERN_OUTPUTS -> SPRITE_PATTERN_OUTPUTS;
            case AutocrafterManagerSearchMode.AUTOCRAFTER_NAMES -> SPRITE_AUTOCRAFTER_NAMES;
        };
    }

    @Override
    protected MutableComponent getTitle() {
        return TITLE;
    }

    @Override
    protected List<MutableComponent> getSubText() {
        return switch (this.containerMenu.getSearchMode()) {
            default -> throw new MatchException(null, null);
            case AutocrafterManagerSearchMode.ALL -> SUBTEXT_ALL;
            case AutocrafterManagerSearchMode.PATTERN_INPUTS -> SUBTEXT_PATTERN_INPUTS;
            case AutocrafterManagerSearchMode.PATTERN_OUTPUTS -> SUBTEXT_PATTERN_OUTPUTS;
            case AutocrafterManagerSearchMode.AUTOCRAFTER_NAMES -> SUBTEXT_AUTOCRAFTER_NAMES;
        };
    }

    @Override
    protected Component getHelpText() {
        return this.helpTextSupplier.get();
    }
}

