/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.surface.rule;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import dev.worldgen.lithostitched.registry.LithostitchedRegistryKeys;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;

public record ReferenceRule(HolderSet<SurfaceRules.RuleSource> rules) implements SurfaceRules.RuleSource
{
    public static final KeyDispatchDataCodec<ReferenceRule> CODEC = KeyDispatchDataCodec.of((MapCodec)RegistryCodecs.homogeneousList(LithostitchedRegistryKeys.SURFACE_RULE).fieldOf("rules").xmap(ReferenceRule::new, ReferenceRule::rules));

    public KeyDispatchDataCodec<? extends SurfaceRules.RuleSource> codec() {
        return CODEC;
    }

    public SurfaceRules.SurfaceRule apply(SurfaceRules.Context context) {
        if (this.rules.size() == 0) {
            return (x, y, z) -> null;
        }
        if (this.rules.size() == 1) {
            return (SurfaceRules.SurfaceRule)((SurfaceRules.RuleSource)this.rules.get(0).value()).apply((Object)context);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SurfaceRules.RuleSource ruleSource : this.rules.stream().map(Holder::value).toList()) {
            builder.add((Object)((SurfaceRules.SurfaceRule)ruleSource.apply((Object)context)));
        }
        return (x, y, z) -> {
            for (SurfaceRules.SurfaceRule surfaceRule : builder.build()) {
                BlockState blockstate = surfaceRule.tryApply(x, y, z);
                if (blockstate == null) continue;
                return blockstate;
            }
            return null;
        };
    }
}

