/*
 * Decompiled with CFR 0.152.
 */
package com.github.Pandarix.beautify.common.block;

import com.github.Pandarix.beautify.core.init.SoundInit;
import com.github.Pandarix.beautify.util.Config;
import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class Blinds
extends HorizontalDirectionalBlock {
    public static final MapCodec<Blinds> BLINDS_MAP_CODEC = Blinds.simpleCodec(Blinds::new);
    private static final VoxelShape OPEN_NORTH = Block.box((double)0.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape OPEN_SOUTH = Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    private static final VoxelShape OPEN_WEST = Block.box((double)13.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape OPEN_EAST = Block.box((double)0.0, (double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    private static final VoxelShape CLOSED_SOUTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape CLOSED_NORTH = Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape CLOSED_EAST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    private static final VoxelShape CLOSED_WEST = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_HIDDEN = Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");
    public static final BooleanProperty HIDDEN = BooleanProperty.create((String)"hidden");

    public Blinds(BlockBehaviour.Properties p_54120_) {
        super(p_54120_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)HIDDEN, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return BLINDS_MAP_CODEC;
    }

    @ParametersAreNonnullByDefault
    public boolean isCollisionShapeFullBlock(BlockState blockState, BlockGetter blockGetter, BlockPos pos) {
        return false;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape getBlockSupportShape(BlockState blockState, BlockGetter blockGetter, BlockPos pos) {
        return Shapes.empty();
    }

    @ParametersAreNonnullByDefault
    public boolean propagatesSkylightDown(BlockState blockState, BlockGetter blockGetter, BlockPos pos) {
        return true;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)HIDDEN, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{OPEN, FACING, HIDDEN});
    }

    @ParametersAreNonnullByDefault
    @NotNull
    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pResult) {
        if (pLevel.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        boolean currentlyOpen = (Boolean)pState.getValue((Property)OPEN);
        if (((Boolean)Config.OPENS_FROM_ROOT.get()).booleanValue()) {
            int step = 1;
            while (this.sameBlindType(pLevel, pPos.above(step), pState)) {
                ++step;
            }
            pPos = pPos.above(step - 1);
        }
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(!currentlyOpen)), 3);
        if ((Integer)Config.SEARCHRADIUS.get() > 0) {
            for (int offsetDown = 1; offsetDown <= (Integer)Config.SEARCHRADIUS.get() && this.sameBlindType(pLevel, pPos.below(offsetDown), pState); ++offsetDown) {
                this.switchOpenUpdateHidden(pLevel, pPos.below(offsetDown), pState, false);
            }
        }
        if ((Integer)Config.SEARCHRADIUS.get() > 0) {
            int offsetDown;
            if (pState.getValue((Property)FACING) == Direction.NORTH || pState.getValue((Property)FACING) == Direction.SOUTH) {
                for (int offsetEast = 1; offsetEast <= (Integer)Config.SEARCHRADIUS.get() / 2 && this.sameBlindType(pLevel, pPos.east(offsetEast), pState); ++offsetEast) {
                    pLevel.setBlock(pPos.east(offsetEast), (BlockState)pState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(!currentlyOpen)), 3);
                    for (offsetDown = 1; offsetDown <= (Integer)Config.SEARCHRADIUS.get() && this.sameBlindType(pLevel, pPos.below(offsetDown).east(offsetEast), pState); ++offsetDown) {
                        this.switchOpenUpdateHidden(pLevel, pPos.below(offsetDown).east(offsetEast), pState, false);
                    }
                }
                for (int offsetWest = 1; offsetWest <= (Integer)Config.SEARCHRADIUS.get() / 2 && this.sameBlindType(pLevel, pPos.west(offsetWest), pState); ++offsetWest) {
                    pLevel.setBlock(pPos.west(offsetWest), (BlockState)pState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(!currentlyOpen)), 3);
                    for (offsetDown = 1; offsetDown <= (Integer)Config.SEARCHRADIUS.get() && this.sameBlindType(pLevel, pPos.below(offsetDown).west(offsetWest), pState); ++offsetDown) {
                        this.switchOpenUpdateHidden(pLevel, pPos.below(offsetDown).west(offsetWest), pState, false);
                    }
                }
            }
            if (pState.getValue((Property)FACING) == Direction.EAST || pState.getValue((Property)FACING) == Direction.WEST) {
                for (int offsetNorth = 1; offsetNorth <= (Integer)Config.SEARCHRADIUS.get() / 2 && this.sameBlindType(pLevel, pPos.north(offsetNorth), pState); ++offsetNorth) {
                    pLevel.setBlock(pPos.north(offsetNorth), (BlockState)pState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(!currentlyOpen)), 3);
                    for (offsetDown = 1; offsetDown <= (Integer)Config.SEARCHRADIUS.get() && this.sameBlindType(pLevel, pPos.below(offsetDown).north(offsetNorth), pState); ++offsetDown) {
                        this.switchOpenUpdateHidden(pLevel, pPos.below(offsetDown).north(offsetNorth), pState, false);
                    }
                }
                for (int offsetSouth = 1; offsetSouth <= (Integer)Config.SEARCHRADIUS.get() / 2 && this.sameBlindType(pLevel, pPos.south(offsetSouth), pState); ++offsetSouth) {
                    pLevel.setBlock(pPos.south(offsetSouth), (BlockState)pState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(!currentlyOpen)), 3);
                    for (offsetDown = 1; offsetDown <= (Integer)Config.SEARCHRADIUS.get() && this.sameBlindType(pLevel, pPos.below(offsetDown).south(offsetSouth), pState); ++offsetDown) {
                        this.switchOpenUpdateHidden(pLevel, pPos.below(offsetDown).south(offsetSouth), pState, false);
                    }
                }
            }
            pLevel.playSound(null, pPos, currentlyOpen ? SoundInit.BLINDS_CLOSE.get() : SoundInit.BLINDS_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(pState, pLevel, pPos, pPlayer, pResult);
    }

    private boolean sameBlindType(Level pLevel, BlockPos pPos, BlockState pState) {
        return pLevel.getBlockState(pPos).getBlock() == this && pLevel.getBlockState(pPos).getValue((Property)FACING) == pState.getValue((Property)FACING);
    }

    private void switchOpenUpdateHidden(Level pLevel, BlockPos pPos, BlockState pState, boolean updateOnly) {
        if (updateOnly) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)HIDDEN, (Comparable)Boolean.valueOf(false)), 3);
            return;
        }
        if (!((Boolean)pState.getValue((Property)OPEN)).booleanValue()) {
            pLevel.setBlock(pPos, (BlockState)((BlockState)pState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true))).setValue((Property)HIDDEN, (Comparable)Boolean.valueOf(false)), 3);
        } else {
            pLevel.setBlock(pPos, (BlockState)((BlockState)pState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)HIDDEN, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (this.sameBlindType(level, pos.below(), state)) {
            this.switchOpenUpdateHidden(level, pos.below(), state, true);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        if (this.sameBlindType(level, pos.below(), state)) {
            this.switchOpenUpdateHidden(level, pos.below(), state, true);
        }
        super.onBlockExploded(state, level, pos, explosion);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)HIDDEN)).booleanValue()) {
            return SHAPE_HIDDEN;
        }
        if (!((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                case Direction.NORTH -> OPEN_NORTH;
                case Direction.SOUTH -> OPEN_SOUTH;
                case Direction.WEST -> OPEN_WEST;
                case Direction.EAST -> OPEN_EAST;
                default -> OPEN_NORTH;
            };
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> CLOSED_NORTH;
            case Direction.SOUTH -> CLOSED_SOUTH;
            case Direction.WEST -> CLOSED_WEST;
            case Direction.EAST -> CLOSED_EAST;
            default -> CLOSED_NORTH;
        };
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        if (!Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"tooltip.shift").withStyle(ChatFormatting.YELLOW));
        } else {
            components.add((Component)Component.translatable((String)"blinds.description1").withStyle(ChatFormatting.GRAY));
            components.add((Component)Component.translatable((String)"blinds.description2").withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, components, flag);
    }
}

