/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.network.c2s;

import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.network.s2c.InventoryUpdateMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public class InventoryRequest
extends Message {
    public static final StreamCodec<RegistryFriendlyByteBuf, InventoryRequest> STREAM_CODEC = StreamCodec.ofMember(InventoryRequest::encode, InventoryRequest::new);
    public static final CustomPacketPayload.Type<InventoryRequest> TYPE = Message.createType("inventory");
    private final int vehicleId;

    public CustomPacketPayload.Type<InventoryRequest> type() {
        return TYPE;
    }

    public InventoryRequest(int id) {
        this.vehicleId = id;
    }

    public InventoryRequest(RegistryFriendlyByteBuf b) {
        this.vehicleId = b.readInt();
    }

    @Override
    public void encode(RegistryFriendlyByteBuf b) {
        b.writeInt(this.vehicleId);
    }

    @Override
    public void receiveServer(ServerPlayer e) {
        Entity entity = e.level().getEntity(this.vehicleId);
        if (entity instanceof InventoryVehicleEntity) {
            InventoryVehicleEntity vehicle = (InventoryVehicleEntity)entity;
            for (int i = 0; i < vehicle.getInventoryDescription().getInventorySize(); ++i) {
                ItemStack stack = vehicle.getInventory().getItem(i);
                if (stack.isEmpty()) continue;
                NetworkHandler.sendToPlayer(new InventoryUpdateMessage(entity, i, stack), e);
            }
        }
    }
}

