/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.item.upgrade.VehicleStat;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public abstract class AirplaneEntity
extends AircraftEntity {
    public AirplaneEntity(EntityType<? extends AircraftEntity> entityType, Level world, boolean canExplodeOnCrash) {
        super(entityType, world, canExplodeOnCrash);
    }

    @Override
    protected boolean useAirplaneControls() {
        return true;
    }

    @Override
    protected double getDefaultGravity() {
        Vector3f direction = this.getForwardDirection();
        float speed = (float)this.getDeltaMovement().length() * (1.0f - Math.abs(direction.y));
        return (double)Math.max(0.0f, 1.0f - speed * 1.5f) * super.getDefaultGravity();
    }

    protected float getBrakeFactor() {
        return 0.95f;
    }

    @Override
    protected void updateController() {
        if (!this.isVehicle()) {
            return;
        }
        super.updateController();
        if (this.movementY != 0.0f) {
            this.setEngineTarget(Math.max(0.0f, Math.min(1.0f, this.getEngineTarget() + 0.1f * this.movementY)));
            if (this.movementY < 0.0f) {
                this.setDeltaMovement(this.getDeltaMovement().scale((double)this.getBrakeFactor()));
            }
        }
        Vector3f direction = this.getForwardDirection();
        float thrust = (float)(Math.pow(this.getEnginePower(), 2.0) * (double)this.getProperties().get(VehicleStat.ENGINE_SPEED));
        if (this.onGround() && (double)this.getEngineTarget() < 1.0) {
            thrust = this.getProperties().get(VehicleStat.PUSH_SPEED) / (1.0f + (float)this.getDeltaMovement().length() * 5.0f) * this.pressingInterpolatedZ.getSmooth() * (1.0f - this.getEnginePower());
        }
        this.setDeltaMovement(this.getDeltaMovement().add(this.toVec3d(direction.mul(thrust))));
    }
}

