/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.resource;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;

public enum ItemResourceRendering implements ResourceRendering
{
    INSTANCE;

    public static final Matrix4f IN_WORLD_SCALE;
    private final Map<ItemResource, ItemStack> stackCache = new HashMap<ItemResource, ItemStack>();

    private ItemStack getStack(ItemResource itemResource) {
        return this.stackCache.computeIfAbsent(itemResource, ItemResource::toItemStack);
    }

    @Override
    public String formatAmount(long amount, boolean withUnits) {
        return !withUnits ? IdentifierUtil.format(amount) : IdentifierUtil.formatWithUnits(amount);
    }

    @Override
    public Component getDisplayName(ResourceKey resource) {
        if (!(resource instanceof ItemResource)) {
            return Component.empty();
        }
        ItemResource itemResource = (ItemResource)resource;
        return this.getStack(itemResource).getHoverName();
    }

    @Override
    public List<Component> getTooltip(ResourceKey resource) {
        if (!(resource instanceof ItemResource)) {
            return Collections.emptyList();
        }
        ItemResource itemResource = (ItemResource)resource;
        Minecraft minecraft = Minecraft.getInstance();
        return this.getStack(itemResource).getTooltipLines(Item.TooltipContext.EMPTY, (Player)minecraft.player, (TooltipFlag)(minecraft.options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL));
    }

    @Override
    public void render(ResourceKey resource, GuiGraphics graphics, int x, int y) {
        if (!(resource instanceof ItemResource)) {
            return;
        }
        ItemResource itemResource = (ItemResource)resource;
        ItemStack stack = this.getStack(itemResource);
        graphics.renderItem(stack, x, y);
        graphics.renderItemDecorations(Minecraft.getInstance().font, stack, x, y);
    }

    @Override
    public void render(ResourceKey resource, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int light, Level level) {
        if (!(resource instanceof ItemResource)) {
            return;
        }
        ItemResource itemResource = (ItemResource)resource;
        ItemStack itemStack = this.getStack(itemResource);
        poseStack.mulPose(IN_WORLD_SCALE);
        poseStack.last().normal().rotateX(-0.7853982f);
        Minecraft.getInstance().getItemRenderer().renderStatic(itemStack, ItemDisplayContext.GUI, light, OverlayTexture.NO_OVERLAY, poseStack, renderTypeBuffer, level, 0);
    }

    static {
        IN_WORLD_SCALE = new Matrix4f().scale(0.3f, 0.3f, 0.001f);
    }
}

