/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.direction;

import com.refinedmods.refinedstorage.common.support.direction.DirectionType;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.EnumProperty;

public class DefaultDirectionType
implements DirectionType<Direction> {
    public static final DirectionType<Direction> FACE_CLICKED = new DefaultDirectionType(false);
    private static final EnumProperty<Direction> PROPERTY = EnumProperty.create((String)"direction", Direction.class);
    private final boolean facePlayer;

    private DefaultDirectionType(boolean facePlayer) {
        this.facePlayer = facePlayer;
    }

    @Override
    public EnumProperty<Direction> getProperty() {
        return PROPERTY;
    }

    @Override
    public Direction getDefault() {
        return Direction.NORTH;
    }

    @Override
    public Direction extractDirection(Direction direction) {
        return direction;
    }

    @Override
    public Direction getDirection(Direction clickedFace, Direction playerFacing, float playerPitch) {
        if (this.facePlayer) {
            if (playerPitch > 65.0f) {
                return Direction.UP;
            }
            if (playerPitch < -65.0f) {
                return Direction.DOWN;
            }
            return playerFacing.getOpposite();
        }
        return clickedFace.getOpposite();
    }

    @Override
    public Direction rotate(Direction direction) {
        Direction[] directions = Direction.values();
        return direction.ordinal() + 1 >= directions.length ? directions[0] : directions[direction.ordinal() + 1];
    }
}

