/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.containermenu;

import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.containermenu.SingleAmountData;
import com.refinedmods.refinedstorage.common.support.packet.c2s.C2SPackets;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;

public abstract class AbstractSingleAmountContainerMenu
extends AbstractResourceContainerMenu {
    private double clientAmount;
    private final Component filterHelpText;
    private final ResourceContainer resourceContainer;

    protected AbstractSingleAmountContainerMenu(MenuType<?> type, int syncId, Inventory playerInventory, SingleAmountData singleAmountData, Component filterHelpText) {
        super(type, syncId);
        this.disabledSlot = singleAmountData.slotReference().orElse(null);
        this.clientAmount = singleAmountData.amount();
        this.filterHelpText = filterHelpText;
        this.resourceContainer = ResourceContainerImpl.createForFilter(singleAmountData.resourceContainerData());
        this.addSlots(playerInventory.player);
    }

    protected AbstractSingleAmountContainerMenu(MenuType<?> type, int syncId, Player player, ResourceContainer resourceContainer, Component filterHelpText, @Nullable SlotReference disabledSlotReference) {
        super(type, syncId, player);
        this.disabledSlot = disabledSlotReference;
        this.filterHelpText = filterHelpText;
        this.resourceContainer = resourceContainer;
        this.addSlots(player);
    }

    private void addSlots(Player player) {
        this.addSlot(new ResourceSlot(this.resourceContainer, 0, this.filterHelpText, 116, 47, ResourceSlotType.FILTER));
        this.addPlayerInventory(player.getInventory(), 8, 106);
        this.transferManager.addFilterTransfer((Container)player.getInventory());
    }

    public double getMinAmount() {
        PlatformResourceKey resource = this.resourceContainer.getResource(0);
        if (resource == null) {
            return 1.0;
        }
        return resource.getResourceType().getDisplayAmount(1L);
    }

    public double getAmount() {
        return this.clientAmount;
    }

    public void changeAmountOnClient(double newAmount) {
        C2SPackets.sendSingleAmountChange(newAmount);
        this.clientAmount = newAmount;
    }

    public abstract void changeAmountOnServer(double var1);
}

