/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.security;

import com.refinedmods.refinedstorage.api.network.security.SecurityPolicy;
import com.refinedmods.refinedstorage.common.api.security.PlatformPermission;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.security.AbstractSecurityCardExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.security.PlayerBoundSecurityCardData;
import com.refinedmods.refinedstorage.common.security.SecurityCardBoundPlayer;
import com.refinedmods.refinedstorage.common.security.SecurityCardContainerMenu;
import com.refinedmods.refinedstorage.common.security.SecurityCardData;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

class SecurityCardExtendedMenuProvider
extends AbstractSecurityCardExtendedMenuProvider<PlayerBoundSecurityCardData> {
    @Nullable
    private final Component name;
    private final MinecraftServer server;
    private final SlotReference slotReference;
    private final SecurityCardBoundPlayer boundPlayer;

    SecurityCardExtendedMenuProvider(@Nullable Component name, MinecraftServer server, SlotReference slotReference, SecurityPolicy securityPolicy, Set<PlatformPermission> dirtyPermissions, SecurityCardBoundPlayer boundPlayer) {
        super(securityPolicy, dirtyPermissions);
        this.name = name;
        this.server = server;
        this.slotReference = slotReference;
        this.boundPlayer = boundPlayer;
    }

    @Override
    public PlayerBoundSecurityCardData getMenuData() {
        return new PlayerBoundSecurityCardData(new SecurityCardData(this.slotReference, this.getDataPermissions()), PlayerBoundSecurityCardData.Player.of(this.boundPlayer), this.server.getPlayerList().getPlayers().stream().map(PlayerBoundSecurityCardData.Player::of).toList());
    }

    @Override
    public StreamEncoder<RegistryFriendlyByteBuf, PlayerBoundSecurityCardData> getMenuCodec() {
        return PlayerBoundSecurityCardData.STREAM_CODEC;
    }

    public Component getDisplayName() {
        return this.name == null ? ContentNames.SECURITY_CARD : this.name;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new SecurityCardContainerMenu(syncId, inventory, this.slotReference);
    }
}

