/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.networking;

import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.content.BlockConstants;
import com.refinedmods.refinedstorage.common.content.Blocks;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterBlockEntity;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterBlockEntityTicker;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterState;
import com.refinedmods.refinedstorage.common.support.AbstractBlockEntityTicker;
import com.refinedmods.refinedstorage.common.support.AbstractColoredBlock;
import com.refinedmods.refinedstorage.common.support.BaseBlockItem;
import com.refinedmods.refinedstorage.common.support.NetworkNodeBlockItem;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class NetworkTransmitterBlock
extends AbstractColoredBlock<NetworkTransmitterBlock>
implements EntityBlock {
    public static final EnumProperty<NetworkTransmitterState> STATE = EnumProperty.create((String)"state", NetworkTransmitterState.class);
    private static final Component HELP = IdentifierUtil.createTranslation("item", "network_transmitter.help");
    private static final AbstractBlockEntityTicker<NetworkTransmitterBlockEntity> TICKER = new NetworkTransmitterBlockEntityTicker();

    public NetworkTransmitterBlock(DyeColor color, MutableComponent name) {
        super(BlockConstants.PROPERTIES, color, name);
    }

    @Override
    protected BlockState getDefaultState() {
        return (BlockState)super.getDefaultState().setValue(STATE, (Comparable)((Object)NetworkTransmitterState.INACTIVE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{STATE});
    }

    @Override
    public BlockColorMap<NetworkTransmitterBlock, BaseBlockItem> getBlockColorMap() {
        return Blocks.INSTANCE.getNetworkTransmitter();
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new NetworkTransmitterBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <O extends BlockEntity> BlockEntityTicker<O> getTicker(Level level, BlockState blockState, BlockEntityType<O> type) {
        return TICKER.get(level, type);
    }

    @Override
    public BaseBlockItem createBlockItem() {
        return new NetworkNodeBlockItem(this, HELP);
    }

    @Override
    public boolean canAlwaysConnect() {
        return true;
    }
}

