/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.detector;

import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.impl.node.detector.AbstractDetectorAmountStrategy;
import com.refinedmods.refinedstorage.api.network.impl.node.detector.DetectorAmountStrategy;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.api.storage.root.FuzzyRootStorage;

class FuzzyDetectorAmountStrategy
extends AbstractDetectorAmountStrategy {
    private final DetectorAmountStrategy fallback;

    FuzzyDetectorAmountStrategy(DetectorAmountStrategy fallback) {
        this.fallback = fallback;
    }

    @Override
    public long getAmount(Network network, ResourceKey configuredResource) {
        RootStorage rootStorage = this.getRootStorage(network);
        if (!(rootStorage instanceof FuzzyRootStorage)) {
            return this.fallback.getAmount(network, configuredResource);
        }
        FuzzyRootStorage fuzzyRootStorage = (FuzzyRootStorage)rootStorage;
        return fuzzyRootStorage.getFuzzy(configuredResource).stream().mapToLong(rootStorage::get).sum();
    }
}

