/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.patterngrid;

import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridRenderer;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternType;
import com.refinedmods.refinedstorage.common.support.widget.CheckboxWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

class CraftingPatternGridRenderer
implements PatternGridRenderer {
    private static final ResourceLocation CRAFTING = IdentifierUtil.createIdentifier("pattern_grid/crafting");
    private static final MutableComponent FUZZY_MODE = IdentifierUtil.createTranslation("gui", "pattern_grid.fuzzy_mode");
    private static final MutableComponent FUZZY_MODE_ON_HELP = IdentifierUtil.createTranslation("gui", "pattern_grid.fuzzy_mode.on.help");
    private static final MutableComponent FUZZY_MODE_OFF_HELP = IdentifierUtil.createTranslation("gui", "pattern_grid.fuzzy_mode.off.help");
    @Nullable
    private CheckboxWidget fuzzyModeCheckbox;
    private final PatternGridContainerMenu menu;
    private final int leftPos;
    private final int x;
    private final int y;

    CraftingPatternGridRenderer(PatternGridContainerMenu menu, int leftPos, int x, int y) {
        this.menu = menu;
        this.leftPos = leftPos;
        this.x = x;
        this.y = y;
    }

    @Override
    public void addWidgets(Consumer<AbstractWidget> widgets, Consumer<AbstractWidget> renderables) {
        this.fuzzyModeCheckbox = this.createFuzzyModeCheckbox();
        renderables.accept((AbstractWidget)this.fuzzyModeCheckbox);
    }

    private CheckboxWidget createFuzzyModeCheckbox() {
        CheckboxWidget checkbox = new CheckboxWidget(this.x + 4, this.y + 4 + 54 + 4 - 2, (Component)FUZZY_MODE, Minecraft.getInstance().font, this.menu.isFuzzyMode(), CheckboxWidget.Size.SMALL);
        checkbox.setOnPressed((c, selected) -> this.menu.setFuzzyMode(selected));
        checkbox.setHelpTooltip(CraftingPatternGridRenderer.getFuzzyModeTooltip(this.menu.isFuzzyMode()));
        checkbox.visible = this.isFuzzyModeCheckboxVisible();
        return checkbox;
    }

    private static Component getFuzzyModeTooltip(boolean fuzzyMode) {
        return fuzzyMode ? FUZZY_MODE_ON_HELP : FUZZY_MODE_OFF_HELP;
    }

    @Override
    public int getClearButtonX() {
        return this.leftPos + 68;
    }

    @Override
    public int getClearButtonY() {
        return this.y + 4;
    }

    @Override
    public void patternTypeChanged(PatternType newPatternType) {
        if (this.fuzzyModeCheckbox != null) {
            this.fuzzyModeCheckbox.visible = this.isFuzzyModeCheckboxVisible();
        }
    }

    private boolean isFuzzyModeCheckboxVisible() {
        return this.menu.getPatternType() == PatternType.CRAFTING;
    }

    @Override
    public void fuzzyModeChanged(boolean newFuzzyMode) {
        if (this.fuzzyModeCheckbox == null) {
            return;
        }
        this.fuzzyModeCheckbox.setSelected(newFuzzyMode);
        this.fuzzyModeCheckbox.setHelpTooltip(CraftingPatternGridRenderer.getFuzzyModeTooltip(newFuzzyMode));
    }

    @Override
    public void renderBackground(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.blitSprite(CRAFTING, this.x + 4, this.y + 4, 130, 54);
    }
}

