/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.common.recipe;

import fonnymunkey.simplehats.SimpleHatsCommon;
import fonnymunkey.simplehats.common.item.HatItem;
import fonnymunkey.simplehats.util.HatEntry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class HatScrapRecipe
extends CustomRecipe {
    public HatScrapRecipe(CraftingBookCategory category) {
        super(category);
    }

    public String getGroup() {
        return "simplehats:hatscraps";
    }

    public boolean matches(CraftingInput craftingInventory, Level level) {
        int[] list = HatScrapRecipe.processInventory(craftingInventory);
        return list[0] != -1 && list[1] != -1;
    }

    public ItemStack assemble(CraftingInput craftingInventory, HolderLookup.Provider lookup) {
        int[] list = HatScrapRecipe.processInventory(craftingInventory);
        if (list[0] != -1 && list[1] != -1) {
            return switch (((HatItem)craftingInventory.getItem(list[0]).getItem()).getHatEntry().getHatSeason()) {
                default -> throw new MatchException(null, null);
                case HatEntry.HatSeason.EASTER -> new ItemStack((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatScrapsEaster());
                case HatEntry.HatSeason.SUMMER -> new ItemStack((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatScrapsSummer());
                case HatEntry.HatSeason.HALLOWEEN -> new ItemStack((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatScrapsHalloween());
                case HatEntry.HatSeason.FESTIVE -> new ItemStack((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatScrapsFestive());
                case HatEntry.HatSeason.NONE -> {
                    switch (((HatItem)craftingInventory.getItem(list[0]).getItem()).getHatEntry().getHatRarity()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case COMMON: {
                            yield new ItemStack((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatScrapsCommon());
                        }
                        case UNCOMMON: {
                            yield new ItemStack((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatScrapsUncommon());
                        }
                        case RARE: 
                        case EPIC: 
                    }
                    yield new ItemStack((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatScrapsRare());
                }
            };
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput craftingInventory) {
        NonNullList remainList = NonNullList.withSize((int)craftingInventory.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < craftingInventory.size(); ++i) {
            ItemStack slot = craftingInventory.getItem(i);
            if (slot.isEmpty() || !(slot.getItem() instanceof ShearsItem)) continue;
            ItemStack slot1 = slot.copy();
            if (slot1.isDamageableItem()) {
                slot1.setDamageValue(slot.getDamageValue() + 1);
                if (slot1.getDamageValue() >= slot1.getMaxDamage()) {
                    slot1 = ItemStack.EMPTY;
                }
            }
            remainList.set(i, (Object)slot1);
            break;
        }
        return remainList;
    }

    private static int[] processInventory(CraftingInput craftingInventory) {
        int totalItems = 0;
        int[] list = new int[]{-1, -1};
        for (int i = 0; i < craftingInventory.size(); ++i) {
            HatItem hat;
            ItemStack slot = craftingInventory.getItem(i);
            if (slot.isEmpty()) continue;
            ++totalItems;
            Item item = slot.getItem();
            if (item instanceof HatItem && (hat = (HatItem)item) != SimpleHatsCommon.MOD_REGISTRY.getHatSpecial()) {
                list[0] = i;
            }
            if (!(slot.getItem() instanceof ShearsItem)) continue;
            list[1] = i;
        }
        if (totalItems == 2) {
            return list;
        }
        return new int[]{-1, -1};
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return SimpleHatsCommon.MOD_REGISTRY.getHatScrapSerializer();
    }
}

