/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.util;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.neoforged.neoforge.common.util.Lazy;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.mixin.AccessorIngredient;
import xfacthd.framedblocks.mixin.AccessorStateDefinitionBuilder;

public final class FramedUtils {
    private static final Lazy<Set<Item>> RAIL_ITEMS = Lazy.of(() -> {
        Set items = Collections.newSetFromMap(new IdentityHashMap());
        items.addAll(Set.of(Items.RAIL, Items.POWERED_RAIL, Items.DETECTOR_RAIL, Items.ACTIVATOR_RAIL, ((Block)FBContent.BLOCK_FRAMED_FANCY_RAIL.value()).asItem(), ((Block)FBContent.BLOCK_FRAMED_FANCY_POWERED_RAIL.value()).asItem(), ((Block)FBContent.BLOCK_FRAMED_FANCY_DETECTOR_RAIL.value()).asItem(), ((Block)FBContent.BLOCK_FRAMED_FANCY_ACTIVATOR_RAIL.value()).asItem()));
        return items;
    });
    private static final Lazy<Map<Item, Block>> RAIL_SLOPE_BLOCKS = Lazy.of(() -> new IdentityHashMap<Item, Block>(Map.of(Items.RAIL, (Block)FBContent.BLOCK_FRAMED_RAIL_SLOPE.value(), Items.POWERED_RAIL, (Block)FBContent.BLOCK_FRAMED_POWERED_RAIL_SLOPE.value(), Items.DETECTOR_RAIL, (Block)FBContent.BLOCK_FRAMED_DETECTOR_RAIL_SLOPE.value(), Items.ACTIVATOR_RAIL, (Block)FBContent.BLOCK_FRAMED_ACTIVATOR_RAIL_SLOPE.value(), ((Block)FBContent.BLOCK_FRAMED_FANCY_RAIL.value()).asItem(), (Block)FBContent.BLOCK_FRAMED_FANCY_RAIL_SLOPE.value(), ((Block)FBContent.BLOCK_FRAMED_FANCY_POWERED_RAIL.value()).asItem(), (Block)FBContent.BLOCK_FRAMED_FANCY_POWERED_RAIL_SLOPE.value(), ((Block)FBContent.BLOCK_FRAMED_FANCY_DETECTOR_RAIL.value()).asItem(), (Block)FBContent.BLOCK_FRAMED_FANCY_DETECTOR_RAIL_SLOPE.value(), ((Block)FBContent.BLOCK_FRAMED_FANCY_ACTIVATOR_RAIL.value()).asItem(), (Block)FBContent.BLOCK_FRAMED_FANCY_ACTIVATOR_RAIL_SLOPE.value())));

    public static boolean isRailItem(Item item) {
        return ((Set)RAIL_ITEMS.get()).contains(item);
    }

    public static Block getRailSlopeBlock(Item item) {
        Block railSlope = (Block)((Map)RAIL_SLOPE_BLOCKS.get()).get(item);
        if (railSlope == null) {
            throw new IllegalStateException("Invalid rail item: " + String.valueOf(item));
        }
        return railSlope;
    }

    public static RailShape getAscendingRailShapeFromDirection(Direction dir) {
        return switch (dir) {
            case Direction.NORTH -> RailShape.ASCENDING_NORTH;
            case Direction.EAST -> RailShape.ASCENDING_EAST;
            case Direction.SOUTH -> RailShape.ASCENDING_SOUTH;
            case Direction.WEST -> RailShape.ASCENDING_WEST;
            default -> throw new IllegalArgumentException("Invalid facing " + String.valueOf(dir));
        };
    }

    public static Direction getDirectionFromAscendingRailShape(RailShape shape) {
        return switch (shape) {
            case RailShape.ASCENDING_NORTH -> Direction.NORTH;
            case RailShape.ASCENDING_EAST -> Direction.EAST;
            case RailShape.ASCENDING_SOUTH -> Direction.SOUTH;
            case RailShape.ASCENDING_WEST -> Direction.WEST;
            default -> throw new IllegalArgumentException("Invalid shape " + String.valueOf(shape));
        };
    }

    public static void enqueueImmediateTask(LevelAccessor level, Runnable task, boolean allowClient) {
        if (level.isClientSide() && allowClient) {
            task.run();
        } else {
            FramedUtils.enqueueTask(level, task, 0);
        }
    }

    public static void enqueueTask(LevelAccessor level, Runnable task, int delay) {
        if (!(level instanceof ServerLevel)) {
            throw new IllegalArgumentException("Utils#enqueueTask() called with a non-ServerWorld");
        }
        ServerLevel slevel = (ServerLevel)level;
        MinecraftServer server = slevel.getServer();
        server.tell((Runnable)new TickTask(server.getTickCount() + delay, task));
    }

    public static void addPlayerInvSlots(Consumer<Slot> slotConsumer, Inventory playerInv, int x, int y) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                slotConsumer.accept(new Slot((Container)playerInv, col + row * 9 + 9, x + col * 18, y));
            }
            y += 18;
        }
        for (int col = 0; col < 9; ++col) {
            slotConsumer.accept(new Slot((Container)playerInv, col, x + col * 18, y + 4));
        }
    }

    public static boolean hasProperty(StateDefinition.Builder<Block, BlockState> builder, Property<?> property) {
        return ((AccessorStateDefinitionBuilder)builder).framedblocks$getProperties().containsKey(property.getName());
    }

    public static void removeProperty(StateDefinition.Builder<Block, BlockState> builder, Property<?> property) {
        Map<String, Property<?>> properties = ((AccessorStateDefinitionBuilder)builder).framedblocks$getProperties();
        properties.remove(property.getName());
    }

    public static Ingredient.Value getSingleIngredientValue(Ingredient ing) {
        Ingredient.Value[] values = ((AccessorIngredient)ing).framedblocks$getValues();
        return values.length == 1 ? values[0] : null;
    }

    private FramedUtils() {
    }
}

