/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.prism;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.DirectionAxis;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;
import xfacthd.framedblocks.common.data.shapes.slope.SlopeShapes;

public final class ElevatedPrismShapes
implements SplitShapeGenerator {
    public static final ElevatedPrismShapes INNER = new ElevatedPrismShapes();

    private ElevatedPrismShapes() {
    }

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return ElevatedPrismShapes.generateShapes(states, SlopeShapes.SHAPES);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return ElevatedPrismShapes.generateShapes(states, SlopeShapes.OCCLUSION_SHAPES);
    }

    private static ShapeProvider generateShapes(ImmutableList<BlockState> states, ShapeCache<SlopeType> shapeCache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeBottom = ShapeUtils.orUnoptimized(shapeCache.get(SlopeType.BOTTOM), ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.SOUTH, shapeCache.get(SlopeType.BOTTOM)));
        VoxelShape shapeTop = ShapeUtils.orUnoptimized(shapeCache.get(SlopeType.TOP), ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.SOUTH, shapeCache.get(SlopeType.TOP)));
        VoxelShape shapeXZ = ShapeUtils.orUnoptimized(shapeCache.get(SlopeType.BOTTOM), shapeCache.get(SlopeType.TOP));
        VoxelShape shapeY = ShapeUtils.orUnoptimized(shapeCache.get(SlopeType.HORIZONTAL), ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.EAST, shapeCache.get(SlopeType.HORIZONTAL)));
        VoxelShape[] shapes = new VoxelShape[12];
        for (DirectionAxis dirAxis : DirectionAxis.values()) {
            Direction facing = dirAxis.direction();
            Direction.Axis axis = dirAxis.axis();
            shapes[dirAxis.ordinal()] = Utils.isY(facing) ? ShapeUtils.rotateShapeAroundY(Direction.EAST, Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE), facing == Direction.UP ? shapeBottom : shapeTop) : ShapeUtils.rotateShapeAroundY(Direction.NORTH, facing.getOpposite(), axis == Direction.Axis.Y ? shapeY : shapeXZ);
        }
        for (BlockState state : states) {
            DirectionAxis dirAxis = (DirectionAxis)((Object)state.getValue(PropertyHolder.FACING_AXIS));
            builder.put((Object)state, (Object)shapes[dirAxis.ordinal()]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

