/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.overlaygen;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import net.neoforged.neoforge.client.model.pipeline.QuadBakingVertexConsumer;
import org.joml.Vector3f;
import xfacthd.framedblocks.client.overlaygen.OverlayCacheKey;
import xfacthd.framedblocks.client.overlaygen.UVInfo;
import xfacthd.framedblocks.common.config.ClientConfig;

public final class OverlayQuadGenerator {
    private static final Map<OverlayCacheKey, BakedQuad> OVERLAY_CACHE = new ConcurrentHashMap<OverlayCacheKey, BakedQuad>();

    public static List<BakedQuad> generate(List<BakedQuad> srcQuads, Function<Direction, TextureAtlasSprite> spriteGetter, Predicate<Direction> filter) {
        ArrayList<BakedQuad> outQuads = new ArrayList<BakedQuad>(srcQuads.size());
        HashSet<OverlayCacheKey> uniqueKeys = new HashSet<OverlayCacheKey>(srcQuads.size());
        for (BakedQuad quad : srcQuads) {
            TextureAtlasSprite sprite;
            OverlayCacheKey key;
            if (!filter.test(quad.getDirection()) || !uniqueKeys.add(key = OverlayQuadGenerator.buildCacheKey(quad, sprite = spriteGetter.apply(quad.getDirection())))) continue;
            outQuads.add(OVERLAY_CACHE.computeIfAbsent(key, OverlayQuadGenerator::generateOverlayQuad));
        }
        return outQuads;
    }

    private static BakedQuad generateOverlayQuad(OverlayCacheKey key) {
        QuadBakingVertexConsumer baker = new QuadBakingVertexConsumer();
        TextureAtlasSprite sprite = key.sprite();
        float shrinkRatio = sprite.uvShrinkRatio();
        UVInfo uvInfo = UVInfo.get(key.face());
        Vector3f scratch = new Vector3f();
        baker.setDirection(key.face());
        baker.setSprite(sprite);
        baker.setHasAmbientOcclusion(true);
        baker.setShade(true);
        for (int i = 0; i < 4; ++i) {
            key.pos(i, scratch);
            baker.addVertex(scratch.x, scratch.y, scratch.z);
            float uSrc = scratch.get(uvInfo.uIdx());
            float vSrc = scratch.get(uvInfo.vIdx());
            float u = Mth.lerp((float)shrinkRatio, (float)(uvInfo.uInv() ? 1.0f - uSrc : uSrc), (float)0.5f);
            float v = Mth.lerp((float)shrinkRatio, (float)(uvInfo.vInv() ? 1.0f - vSrc : vSrc), (float)0.5f);
            if (ClientConfig.VIEW.useDiscreteUVSteps()) {
                if (!Mth.equal((float)uSrc, (float)0.0f) && !Mth.equal((float)uSrc, (float)1.0f)) {
                    u = (float)Math.round(u * 128.0f) / 128.0f;
                }
                if (!Mth.equal((float)vSrc, (float)0.0f) && !Mth.equal((float)vSrc, (float)1.0f)) {
                    v = (float)Math.round(v * 128.0f) / 128.0f;
                }
            }
            baker.setUv(sprite.getU(u), sprite.getV(v));
            key.normal(i, scratch);
            baker.setNormal(scratch.x, scratch.y, scratch.z).setColor(-1);
        }
        return baker.bakeQuad();
    }

    private static OverlayCacheKey buildCacheKey(BakedQuad quad, TextureAtlasSprite sprite) {
        int[] vertexData = quad.getVertices();
        int[] keyData = new int[16];
        for (int i = 0; i < 4; ++i) {
            int srcPos = i * IQuadTransformer.STRIDE;
            int destPos = i * 4;
            System.arraycopy(vertexData, srcPos + IQuadTransformer.POSITION, keyData, destPos, 3);
            keyData[destPos + 3] = vertexData[srcPos + IQuadTransformer.NORMAL];
        }
        return new OverlayCacheKey(quad.getDirection(), keyData, sprite);
    }

    public static void onResourceReload(ResourceManager resourceManager) {
        OVERLAY_CACHE.clear();
    }

    private OverlayQuadGenerator() {
    }
}

