/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.stairs;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedHalfStairsGeometry
extends Geometry {
    private final Direction dir;
    private final boolean top;
    private final boolean right;

    public FramedHalfStairsGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.top = (Boolean)ctx.state().getValue((Property)FramedProperties.TOP);
        this.right = (Boolean)ctx.state().getValue((Property)PropertyHolder.RIGHT);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction vertCut;
        Direction face = quad.getDirection();
        Direction direction = vertCut = this.right ? this.dir.getCounterClockWise() : this.dir.getClockWise();
        if (face == this.dir) {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(vertCut, 0.5f)).export(quadMap.get(face));
        } else if (face == this.dir.getOpposite()) {
            QuadModifier mod = QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(vertCut, 0.5f));
            mod.derive().apply(Modifiers.cutSideUpDown(!this.top, 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            mod.apply(Modifiers.cutSideUpDown(this.top, 0.5f)).export(quadMap.get(face));
        } else if (!Utils.isY(face) && face.getAxis() != this.dir.getAxis()) {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), 0.5f)).applyIf(Modifiers.setPosition(0.5f), face == vertCut).export(quadMap.get(face == vertCut ? null : face));
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir, 0.5f)).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).applyIf(Modifiers.setPosition(0.5f), face == vertCut).export(quadMap.get(face == vertCut ? null : face));
        } else if (Utils.isY(face)) {
            boolean base = face == Direction.UP && this.top || face == Direction.DOWN && !this.top;
            QuadModifier mod = QuadModifier.of(quad).apply(Modifiers.cutTopBottom(vertCut, 0.5f));
            if (!base) {
                mod.derive().apply(Modifiers.cutTopBottom(this.dir, 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            }
            mod.applyIf(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.5f), !base).export(quadMap.get(face));
        }
    }
}

