/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.cube;

import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;

public class FramedBookshelfGeometry
extends Geometry {
    private final BlockState state;
    private final BakedModel baseModel;
    private final Predicate<Direction> frontFacePred;

    private FramedBookshelfGeometry(GeometryFactory.Context ctx, Predicate<Direction> frontFacePred) {
        this.state = ctx.state();
        this.baseModel = ctx.baseModel();
        this.frontFacePred = frontFacePred;
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (Utils.isY(quadDir) || !this.frontFacePred.test(quadDir)) {
            return;
        }
        ArrayList<BakedQuad> quads = quadMap.get(quadDir);
        QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(true, 0.0625f)).export(quads);
        QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, 0.0625f)).export(quads);
        QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(true, 0.0625f)).apply(Modifiers.cutSideUpDown(0.9375f)).export(quads);
        QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(false, 0.0625f)).apply(Modifiers.cutSideUpDown(0.9375f)).export(quads);
        QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(0.5625f)).apply(Modifiers.cutSideLeftRight(0.9375f)).export(quads);
    }

    @Override
    public ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData extraData) {
        return ModelUtils.CUTOUT;
    }

    @Override
    public void getAdditionalQuads(QuadMap quadMap, RandomSource rand, ModelData data, RenderType renderType) {
        if (renderType == RenderType.cutout()) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                quadMap.get(dir).addAll(this.baseModel.getQuads(this.state, dir, rand, data, renderType));
            }
        }
    }

    public static FramedBookshelfGeometry normal(GeometryFactory.Context ctx) {
        return new FramedBookshelfGeometry(ctx, dir -> true);
    }

    public static FramedBookshelfGeometry chiseled(GeometryFactory.Context ctx) {
        Direction facing = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        return new FramedBookshelfGeometry(ctx, arg_0 -> facing.equals(arg_0));
    }
}

