/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.patchouli;

import com.buuz135.industrial.block.core.tile.DissolutionChamberTile;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import vazkii.patchouli.client.book.page.abstr.PageDoubleRecipeRegistry;

public class PageDissolution
extends PageDoubleRecipeRegistry<DissolutionChamberRecipe> {
    public final ResourceLocation patchouliTexture = ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"textures/gui/patchouli.png");

    public PageDissolution() {
        super((RecipeType)ModuleCore.DISSOLUTION_TYPE.get());
    }

    protected void drawRecipe(GuiGraphics graphics, DissolutionChamberRecipe recipe, int recipeX, int recipeY, int mouseX, int mouseY, boolean second) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        RenderSystem.enableBlend();
        graphics.blit(this.patchouliTexture, recipeX - 6, recipeY, 0.0f, 0.0f, 128, 70, 128, 128);
        this.parent.drawCenteredStringNoShadow(graphics, this.getTitle(second).getVisualOrderText(), 58, recipeY - 10, this.book.headerColor);
        for (int i = 0; i < recipe.input.size(); ++i) {
            this.parent.renderIngredient(graphics, recipeX + (Integer)DissolutionChamberTile.getSlotPos(i).getLeft(), recipeY + (Integer)DissolutionChamberTile.getSlotPos(i).getRight() + 6, mouseX, mouseY, recipe.input.get(i));
        }
        if (recipe.inputFluid != null && !recipe.inputFluid.ingredient().isEmpty()) {
            Optional<FluidStack> optionalInputFluid = Arrays.stream(recipe.inputFluid.getFluids()).findFirst();
            optionalInputFluid.ifPresent(fluidStack -> this.renderFluid(graphics, recipeX + 22, recipeY + 28, mouseX, mouseY, (FluidStack)fluidStack));
        }
        if (!recipe.output.isEmpty()) {
            ItemStack stack = recipe.output.get();
            stack.getItem().onCraftedBy(stack, null, null);
            this.parent.renderItemStack(graphics, recipeX + 79, recipeY + 28, mouseX, mouseY, stack);
        }
        this.parent.renderItemStack(graphics, recipeX + 79, recipeY + 49, mouseX, mouseY, recipe.getToastSymbol());
    }

    protected ItemStack getRecipeOutput(Level level, DissolutionChamberRecipe recipe) {
        if (recipe == null || level == null) {
            return ItemStack.EMPTY;
        }
        return recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
    }

    protected int getRecipeHeight() {
        return 70;
    }

    private void renderFluid(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, FluidStack fluid) {
        TextureAtlas atlas;
        TextureAtlasSprite sprite;
        if (fluid == null || fluid.isEmpty()) {
            return;
        }
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        ResourceLocation flowing = fluidTypeExtensions.getStillTexture(fluid);
        AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(InventoryMenu.BLOCK_ATLAS);
        if (texture instanceof TextureAtlas && (sprite = (atlas = (TextureAtlas)texture).getSprite(flowing)) != null) {
            int color = fluidTypeExtensions.getTintColor(fluid);
            int red = FastColor.ARGB32.red((int)color);
            int green = FastColor.ARGB32.green((int)color);
            int blue = FastColor.ARGB32.blue((int)color);
            int alpha = FastColor.ARGB32.alpha((int)color);
            graphics.blit(x, y, 0, 16, 16, sprite, (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
            if (this.parent.isMouseInRelativeRange((double)mouseX, (double)mouseY, x, y, 16, 16)) {
                this.parent.setTooltip(List.of(fluid.getHoverName(), Component.literal((String)(fluid.getAmount() + " mB")).withStyle(ChatFormatting.GRAY)));
            }
        }
    }
}

