/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.entity;

import com.buuz135.industrial.item.infinity.item.ItemInfinityNuke;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.proxy.client.sound.TickeableSound;
import com.buuz135.industrial.utils.IFAttachments;
import com.buuz135.industrial.utils.explosion.ExplosionTickHandler;
import com.buuz135.industrial.utils.explosion.ProcessExplosion;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class InfinityNukeEntity
extends Entity {
    private static final EntityDataAccessor<Integer> RADIUS = SynchedEntityData.defineId(InfinityNukeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> EXPLODING = SynchedEntityData.defineId(InfinityNukeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ARMED = SynchedEntityData.defineId(InfinityNukeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> TICKS = SynchedEntityData.defineId(InfinityNukeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    @Nullable
    private LivingEntity placedBy;
    private ItemStack original = new ItemStack((ItemLike)ModuleTool.INFINITY_NUKE.get());
    private boolean exploding = false;
    private boolean armed = false;
    private int radius = 1;
    private int ticksExploding = 1;
    private ProcessExplosion explosionHelper;
    @OnlyIn(value=Dist.CLIENT)
    private TickeableSound chargingSound;
    @OnlyIn(value=Dist.CLIENT)
    private TickeableSound explodingSound;

    public InfinityNukeEntity(EntityType<? extends InfinityNukeEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.blocksBuilding = true;
    }

    public InfinityNukeEntity(Level worldIn, LivingEntity owner, ItemStack original) {
        this((EntityType<? extends InfinityNukeEntity>)((EntityType)ModuleTool.INFINITY_NUKE_ENTITY_TYPE.value()), worldIn);
        this.placedBy = owner;
        this.original = original;
        this.radius = ItemInfinityNuke.getRadius(original);
        this.entityData.set(RADIUS, (Object)this.radius);
    }

    public void tick() {
        super.tick();
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
        }
        if (this.exploding) {
            if (this.level() instanceof ServerLevel && this.explosionHelper == null) {
                this.explosionHelper = new ProcessExplosion(this.blockPosition(), this.getRadius(), (ServerLevel)this.level(), 39, this.placedBy != null ? this.placedBy.getDisplayName().getString() : "");
                ExplosionTickHandler.processExplosionList.add(this.explosionHelper);
            }
            this.setTicksExploding(this.getTicksExploding() + 1);
            this.updateInWaterStateAndDoFluidPushing();
        }
        if (this.level().isClientSide && ((Boolean)this.getEntityData().get(EXPLODING)).booleanValue() && this.level().isClientSide) {
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + 1.1, this.getZ(), 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, this.level().getBlockState(this.blockPosition().below())), this.getX() + this.level().getRandom().nextDouble() - 0.5, this.getY(), this.getZ() + this.level().getRandom().nextDouble() - 0.5, 0.0, 0.0, 0.0);
        }
        if (this.explosionHelper != null && this.explosionHelper.isDead) {
            this.remove(Entity.RemovalReason.KILLED);
            this.onClientRemoval();
        }
        if (this.level().isClientSide) {
            this.tickClient();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickClient() {
        if (this.chargingSound == null && ((Boolean)this.getEntityData().get(EXPLODING)).booleanValue()) {
            this.chargingSound = new TickeableSound(this.level(), this.blockPosition(), (SoundEvent)ModuleTool.NUKE_CHARGING.get(), this.getRadius(), 10, this.level().random);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)this.chargingSound);
        }
        if (this.chargingSound != null) {
            this.chargingSound.setDistance(this.getRadius());
            this.chargingSound.increase();
            if (!Minecraft.getInstance().getSoundManager().isActive((SoundInstance)this.chargingSound) && this.explodingSound == null) {
                this.explodingSound = new TickeableSound(this.level(), this.blockPosition(), (SoundEvent)ModuleTool.NUKE_EXPLOSION.get(), this.getRadius(), 10, this.level().random);
                this.explodingSound.setPitch(1.0f);
                Minecraft.getInstance().getSoundManager().play((SoundInstance)this.explodingSound);
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(RADIUS, (Object)1);
        builder.define(EXPLODING, (Object)false);
        builder.define(ARMED, (Object)false);
        builder.define(TICKS, (Object)1);
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.put("Original", this.getOriginal().saveOptional((HolderLookup.Provider)IFAttachments.registryAccess()));
        compound.putBoolean("Exploding", this.isExploding());
        compound.putBoolean("Armed", this.isArmed());
        compound.putInt("TicksExploding", this.getTicksExploding());
        compound.putInt("Radius", this.getRadius());
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setArmed(compound.getBoolean("Armed"));
        this.setExploding(compound.getBoolean("Exploding"));
        this.setOriginal(ItemStack.parseOptional((HolderLookup.Provider)IFAttachments.registryAccess(), (CompoundTag)compound.getCompound("Original")));
        this.setTicksExploding(compound.getInt("TicksExploding"));
        this.setRadius(compound.getInt("Radius"));
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.isExploding()) {
            return InteractionResult.SUCCESS;
        }
        if (player.level().isClientSide && hand == InteractionHand.MAIN_HAND && player.getItemInHand(hand).isEmpty()) {
            this.arm();
        }
        if (!player.level().isClientSide && hand == InteractionHand.MAIN_HAND) {
            if (player.getItemInHand(hand).isEmpty()) {
                if (player.isShiftKeyDown()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.original);
                    this.remove(Entity.RemovalReason.KILLED);
                    this.onClientRemoval();
                    return InteractionResult.SUCCESS;
                }
                this.setArmed(!this.isArmed());
                return InteractionResult.SUCCESS;
            }
            if (!this.isExploding() && this.isArmed() && player.getItemInHand(hand).getItem().equals(Items.FLINT_AND_STEEL)) {
                this.setExploding(true);
                this.setNoGravity(true);
                player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                return InteractionResult.SUCCESS;
            }
        }
        return super.interact(player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void arm() {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new SimpleSoundInstance((SoundEvent)ModuleTool.NUKE_ARMING.get(), SoundSource.BLOCKS, 1.0f, 1.0f, Minecraft.getInstance().level.random, this.blockPosition()));
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    public ItemStack getOriginal() {
        return this.original;
    }

    public void setOriginal(ItemStack original) {
        this.original = original;
    }

    public boolean isExploding() {
        return this.exploding;
    }

    public void setExploding(boolean exploding) {
        this.exploding = exploding;
        this.getEntityData().set(EXPLODING, (Object)exploding);
    }

    public boolean isArmed() {
        return this.armed;
    }

    public void setArmed(boolean armed) {
        this.armed = armed;
        this.getEntityData().set(ARMED, (Object)armed);
    }

    public int getRadius() {
        return (Integer)this.getEntityData().get(RADIUS);
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.getEntityData().set(RADIUS, (Object)radius);
    }

    public boolean isDataArmed() {
        return (Boolean)this.getEntityData().get(ARMED);
    }

    public boolean isDataExploding() {
        return (Boolean)this.getEntityData().get(EXPLODING);
    }

    public int getTicksExploding() {
        return this.ticksExploding;
    }

    public void setTicksExploding(int ticksExploding) {
        this.ticksExploding = ticksExploding;
        this.getEntityData().set(TICKS, (Object)ticksExploding);
    }

    public int getDataTicksExploding() {
        return (Integer)this.getEntityData().get(TICKS);
    }
}

