/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.tile;

import com.buuz135.industrial.block.tile.IndustrialGeneratorTile;
import com.buuz135.industrial.config.machine.generator.PitifulGeneratorConfig;
import com.buuz135.industrial.module.ModuleGenerator;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;

public class PitifulGeneratorTile
extends IndustrialGeneratorTile<PitifulGeneratorTile> {
    private int getPowerPerTick;
    @Save
    private SidedInventoryComponent<PitifulGeneratorTile> fuel = (SidedInventoryComponent)new SidedInventoryComponent("fuel_input", 46, 22, 1, 0).setColor(DyeColor.ORANGE).setInputFilter((itemStack, integer) -> itemStack.getBurnTime(RecipeType.SMELTING) != 0).setComponentHarness((IComponentHarness)this);

    public PitifulGeneratorTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleGenerator.PITIFUL_GENERATOR, blockPos, blockState);
        this.addInventory((InventoryComponent)this.fuel);
        this.getPowerPerTick = PitifulGeneratorConfig.powerPerTick;
    }

    public int consumeFuel() {
        int time = this.fuel.getStackInSlot(0).getBurnTime(RecipeType.SMELTING);
        if (this.fuel.getStackInSlot(0).hasCraftingRemainingItem()) {
            this.fuel.setStackInSlot(0, this.fuel.getStackInSlot(0).getCraftingRemainingItem());
        } else {
            this.fuel.getStackInSlot(0).shrink(1);
        }
        return time;
    }

    public boolean canStart() {
        return !this.fuel.getStackInSlot(0).isEmpty() && this.fuel.getStackInSlot(0).getBurnTime(RecipeType.SMELTING) != 0;
    }

    public int getEnergyProducedEveryTick() {
        return this.getPowerPerTick;
    }

    public ProgressBarComponent<PitifulGeneratorTile> getProgressBar() {
        return new ProgressBarComponent(30, 20, 0, 100).setComponentHarness((IComponentHarness)this).setBarDirection(ProgressBarComponent.BarDirection.VERTICAL_UP).setColor(DyeColor.CYAN);
    }

    public int getEnergyCapacity() {
        return PitifulGeneratorConfig.maxStoredPower;
    }

    public int getExtractingEnergy() {
        return PitifulGeneratorConfig.extractionRate;
    }

    public boolean isSmart() {
        return false;
    }

    @Nonnull
    public PitifulGeneratorTile getSelf() {
        return this;
    }
}

