/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.configlib.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.supermartijn642.configlib.ConfigFile;
import com.supermartijn642.configlib.ConfigLib;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

public class JsonConfigFile
implements ConfigFile<JsonElement> {
    private static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().create();
    private final File file;
    private JsonObject json = new JsonObject();
    private boolean tracking = false;

    public JsonConfigFile(File file) {
        this.file = file;
    }

    public JsonElement get(String[] path, String key) {
        if (path.length == 0) {
            return this.json;
        }
        JsonObject object = this.json;
        for (int i = 0; i < path.length; ++i) {
            JsonElement member = object.get(path[i]);
            if (member == null || !member.isJsonObject()) {
                return null;
            }
            object = member.getAsJsonObject();
        }
        return object.get(key);
    }

    private void set(String[] path, String key, JsonElement element) {
        JsonObject object = this.json;
        for (String s : path) {
            JsonElement member = object.get(s);
            if (member == null || !member.isJsonObject()) {
                JsonObject newObject = new JsonObject();
                object.add(s, (JsonElement)newObject);
                object = newObject;
                continue;
            }
            object = member.getAsJsonObject();
        }
        object.add(key, element);
    }

    @Override
    public void setValue(String[] path, JsonElement value) {
        this.set(path, "value", value);
    }

    @Override
    public JsonElement getValue(String[] path) {
        return this.get(path, "value");
    }

    @Override
    public void setComment(String[] path, String comment) {
        this.set(path, "comment", (JsonElement)new JsonPrimitive(comment));
    }

    @Override
    public void setAllowedValuesHint(String[] path, String hint) {
        this.set(path, "hint", (JsonElement)new JsonPrimitive(hint));
    }

    @Override
    public void clearValues() {
        this.json = new JsonObject();
    }

    @Override
    public void startTrackingFile() {
        WatchService watchService;
        if (this.tracking) {
            throw new IllegalStateException("Config file is already being tracked!");
        }
        Path parentPath = this.file.getParentFile().toPath();
        try {
            watchService = parentPath.getFileSystem().newWatchService();
            parentPath.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
        }
        catch (Exception e) {
            ConfigLib.LOGGER.error("Failed to create watch service for config file!", (Throwable)e);
            return;
        }
        this.tracking = true;
        Thread watchThread = new Thread(() -> {
            while (true) {
                WatchKey watchKey;
                try {
                    watchKey = watchService.take();
                }
                catch (Exception e) {
                    this.tracking = false;
                    break;
                }
                for (WatchEvent<?> pollEvent : watchKey.pollEvents()) {
                    Path path = (Path)pollEvent.context();
                    if (!this.file.getName().equals(path.toString())) continue;
                    this.readFile();
                    break;
                }
                watchKey.reset();
            }
        }, "Config Lib config file watcher");
        watchThread.setDaemon(true);
        watchThread.start();
    }

    @Override
    public void readFile() {
        if (!this.file.exists() || this.file.isDirectory()) {
            this.json = new JsonObject();
            return;
        }
        try (JsonReader reader = GSON.newJsonReader((Reader)new FileReader(this.file));){
            this.json = (JsonObject)GSON.fromJson(reader, JsonObject.class);
        }
        catch (Exception e) {
            ConfigLib.LOGGER.error("Failed to read json file '" + this.file.getPath() + "'!", (Throwable)e);
            this.json = new JsonObject();
        }
    }

    @Override
    public void writeFile() {
        if (!this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        try (JsonWriter writer = GSON.newJsonWriter((Writer)new FileWriter(this.file));){
            GSON.toJson((JsonElement)this.json, writer);
        }
        catch (Exception e) {
            ConfigLib.LOGGER.error("Failed to write json file '" + this.file.getPath() + "'!", (Throwable)e);
        }
    }
}

