/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.menu;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class ArmorSlotTypes
implements UniqueSlotHandling.RegistrationCallback {
    private static final Accessory armorAccessory = new Accessory(){

        @Override
        @Nullable
        public SoundEventData getEquipSound(ItemStack stack, SlotReference reference) {
            Holder holder;
            Item item = stack.getItem();
            if (item instanceof Equipable) {
                Equipable equipable = (Equipable)item;
                holder = equipable.getEquipSound();
            } else {
                holder = SoundEvents.ARMOR_EQUIP_GENERIC;
            }
            Holder sound = holder;
            return new SoundEventData((Holder<SoundEvent>)sound, 1.0f, 1.0f);
        }
    };
    public static final Map<EquipmentSlot, ResourceLocation> TEXTURE_EMPTY_SLOTS = Map.of(EquipmentSlot.FEET, ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_boots"), EquipmentSlot.LEGS, ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_leggings"), EquipmentSlot.CHEST, ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_chestplate"), EquipmentSlot.HEAD, ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_helmet"));
    public static final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static final ArmorSlotTypes INSTANCE = new ArmorSlotTypes();
    private static final ResourceLocation HEAD_PREDICATE_LOCATION = Accessories.of("head");
    private static final ResourceLocation CHEST_PREDICATE_LOCATION = Accessories.of("chest");
    private static final ResourceLocation LEGS_PREDICATE_LOCATION = Accessories.of("legs");
    private static final ResourceLocation FEET_PREDICATE_LOCATION = Accessories.of("feet");
    private static final ResourceLocation ANIMAL_BODY_PREDICATE_LOCATION = Accessories.of("animal_body");
    private SlotTypeReference headSlotReference = null;
    private SlotTypeReference chestSlotReference = null;
    private SlotTypeReference legsSlotReference = null;
    private SlotTypeReference feetSlotReference = null;
    private SlotTypeReference animalBodySlotReference = null;
    public static final ResourceLocation SPRITE_ATLAS_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/atlas/gui.png");
    private static final ResourceLocation LLAMA_ARMOR_SLOT_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/horse/llama_armor_slot");
    private static final ResourceLocation HORSE_ARMOR_SLOT_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/horse/armor_slot");

    private ArmorSlotTypes() {
    }

    public static boolean isArmorType(String slotType) {
        return ArmorSlotTypes.headSlot().slotName().equals(slotType) || ArmorSlotTypes.chestSlot().slotName().equals(slotType) || ArmorSlotTypes.legsSlot().slotName().equals(slotType) || ArmorSlotTypes.feetSlot().slotName().equals(slotType);
    }

    public static SlotTypeReference headSlot() {
        return ArmorSlotTypes.INSTANCE.headSlotReference;
    }

    public static SlotTypeReference chestSlot() {
        return ArmorSlotTypes.INSTANCE.chestSlotReference;
    }

    public static SlotTypeReference legsSlot() {
        return ArmorSlotTypes.INSTANCE.legsSlotReference;
    }

    public static SlotTypeReference feetSlot() {
        return ArmorSlotTypes.INSTANCE.feetSlotReference;
    }

    public static SlotTypeReference animalBody() {
        return ArmorSlotTypes.INSTANCE.animalBodySlotReference;
    }

    public static List<SlotTypeReference> getArmorReferences() {
        return List.of(ArmorSlotTypes.headSlot(), ArmorSlotTypes.chestSlot(), ArmorSlotTypes.legsSlot(), ArmorSlotTypes.feetSlot());
    }

    @Nullable
    public static @Nullable Pair<@Nullable ResourceLocation, ResourceLocation> getEmptyTexture(EquipmentSlot slot, LivingEntity living) {
        AbstractHorse horse;
        ResourceLocation texture = TEXTURE_EMPTY_SLOTS.get(slot);
        if (texture != null) {
            return Pair.of(null, (Object)texture);
        }
        if (living instanceof AbstractHorse && (horse = (AbstractHorse)living).canUseSlot(EquipmentSlot.BODY)) {
            if (horse instanceof Llama) {
                return Pair.of((Object)SPRITE_ATLAS_LOCATION, (Object)LLAMA_ARMOR_SLOT_SPRITE);
            }
            return Pair.of((Object)SPRITE_ATLAS_LOCATION, (Object)HORSE_ARMOR_SLOT_SPRITE);
        }
        return null;
    }

    @Nullable
    public static SlotTypeReference getReferenceFromSlot(EquipmentSlot equipmentSlot) {
        return switch (equipmentSlot) {
            case EquipmentSlot.HEAD -> ArmorSlotTypes.headSlot();
            case EquipmentSlot.CHEST -> ArmorSlotTypes.chestSlot();
            case EquipmentSlot.LEGS -> ArmorSlotTypes.legsSlot();
            case EquipmentSlot.FEET -> ArmorSlotTypes.feetSlot();
            case EquipmentSlot.BODY -> ArmorSlotTypes.animalBody();
            default -> null;
        };
    }

    public static boolean isValidEquipable(EquipmentSlot equipmentSlot) {
        return switch (equipmentSlot) {
            case EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET, EquipmentSlot.BODY -> true;
            default -> false;
        };
    }

    public void init() {
        UniqueSlotHandling.EVENT.register((Object)this);
        AccessoriesAPI.registerPredicate(HEAD_PREDICATE_LOCATION, (level, entity, slotType, slot, stack) -> ArmorSlotTypes.isValid(entity, stack, EquipmentSlot.HEAD));
        AccessoriesAPI.registerPredicate(CHEST_PREDICATE_LOCATION, (level, entity, slotType, slot, stack) -> ArmorSlotTypes.isValid(entity, stack, EquipmentSlot.CHEST));
        AccessoriesAPI.registerPredicate(LEGS_PREDICATE_LOCATION, (level, entity, slotType, slot, stack) -> ArmorSlotTypes.isValid(entity, stack, EquipmentSlot.LEGS));
        AccessoriesAPI.registerPredicate(FEET_PREDICATE_LOCATION, (level, entity, slotType, slot, stack) -> ArmorSlotTypes.isValid(entity, stack, EquipmentSlot.FEET));
        AccessoriesAPI.registerPredicate(ANIMAL_BODY_PREDICATE_LOCATION, (level, entity, slotType, slot, stack) -> ArmorSlotTypes.isValid(entity, stack, EquipmentSlot.BODY));
    }

    public void registerAccessories(Consumer<TriConsumer<Integer, ResourceLocation, Item>> eventRegister) {
        BuiltInRegistries.ITEM.forEach(this::tryToRegisterItem);
        eventRegister.accept((TriConsumer<Integer, ResourceLocation, Item>)((TriConsumer)(integer, resourceLocation, item) -> this.tryToRegisterItem((Item)item)));
    }

    private void tryToRegisterItem(Item item) {
        Accessory accessory;
        Equipable equipable;
        if (item instanceof Equipable && ArmorSlotTypes.isValidEquipable((equipable = (Equipable)item).getEquipmentSlot()) && (accessory = AccessoriesAPI.getAccessory(item)) == null) {
            AccessoriesAPI.registerAccessory(item, armorAccessory);
        }
    }

    @Override
    public void registerSlots(UniqueSlotHandling.UniqueSlotBuilderFactory factory) {
        this.headSlotReference = factory.create(Accessories.of("head"), 1).allowTooltipInfo(false).slotPredicates(HEAD_PREDICATE_LOCATION).strictMode(true).allowResizing(false).allowEquipFromUse(false).validTypes(EntityType.PLAYER, EntityType.ARMOR_STAND).build();
        this.chestSlotReference = factory.create(Accessories.of("chest"), 1).allowTooltipInfo(false).slotPredicates(CHEST_PREDICATE_LOCATION).strictMode(true).allowResizing(false).allowEquipFromUse(false).validTypes(EntityType.PLAYER, EntityType.ARMOR_STAND).build();
        this.legsSlotReference = factory.create(Accessories.of("legs"), 1).allowTooltipInfo(false).slotPredicates(LEGS_PREDICATE_LOCATION).strictMode(true).allowResizing(false).allowEquipFromUse(false).validTypes(EntityType.PLAYER, EntityType.ARMOR_STAND).build();
        this.feetSlotReference = factory.create(Accessories.of("feet"), 1).allowTooltipInfo(false).slotPredicates(FEET_PREDICATE_LOCATION).strictMode(true).allowResizing(false).allowEquipFromUse(false).validTypes(EntityType.PLAYER, EntityType.ARMOR_STAND).build();
        this.animalBodySlotReference = factory.create(Accessories.of("animal_body"), 1).allowTooltipInfo(false).slotPredicates(ANIMAL_BODY_PREDICATE_LOCATION).strictMode(true).allowResizing(false).allowEquipFromUse(false).validTypes(EntityType.HORSE, EntityType.WOLF).build();
    }

    private static TriState isValid(LivingEntity livingEntity, ItemStack stack, EquipmentSlot equipmentSlot) {
        EquipmentSlot stackEquipmentSlot = null;
        if (livingEntity == null) {
            Equipable equipable = Equipable.get((ItemStack)stack);
            if (equipable != null) {
                stackEquipmentSlot = equipable.getEquipmentSlot();
            }
        } else {
            stackEquipmentSlot = livingEntity.getEquipmentSlotForItem(stack);
        }
        return equipmentSlot.equals((Object)stackEquipmentSlot) ? TriState.TRUE : TriState.DEFAULT;
    }

    @Nullable
    public static ItemStack getAlternativeStack(LivingEntity instance, EquipmentSlot equipmentSlot) {
        AccessoriesContainer container;
        SlotTypeReference reference;
        AccessoriesCapability capability = instance.accessoriesCapability();
        if (capability != null && (reference = ArmorSlotTypes.getReferenceFromSlot(equipmentSlot)) != null && (container = capability.getContainer(reference)) != null) {
            if (!container.shouldRender(0)) {
                return ItemStack.EMPTY;
            }
            ItemStack stack = container.getCosmeticAccessories().getItem(0);
            if (!stack.isEmpty() && Accessories.config().clientOptions.showCosmeticAccessories()) {
                return stack;
            }
        }
        return null;
    }
}

