/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.glass;

import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.wurstclient.glass.MoGlassBlocks;
import net.wurstclient.glass.StainedGlassStairsBlock;
import net.wurstclient.glass.test.MoGlassTestClient;

@Mod(value="mo_glass")
@EventBusSubscriber(modid="mo_glass", bus=EventBusSubscriber.Bus.MOD)
public final class MoGlass {
    public static final String MODID = "mo_glass";
    private static boolean initialized;

    public MoGlass(IEventBus modBus, ModContainer container) {
        if (initialized) {
            throw new RuntimeException("MoGlass constructor ran twice!");
        }
        initialized = true;
        System.out.println("Starting Mo Glass...");
        MoGlassBlocks.BLOCKS.register(modBus);
        MoGlassBlocks.ITEMS.register(modBus);
        if (System.getProperty("mo_glass.e2eTest") != null) {
            MoGlassTestClient.start();
        }
    }

    @SubscribeEvent
    public static void onBuildCreativeTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() != CreativeModeTabs.COLORED_BLOCKS) {
            return;
        }
        event.accept(MoGlassBlocks.GLASS_STAIRS);
        event.accept(MoGlassBlocks.TINTED_GLASS_STAIRS);
        for (DeferredBlock<StainedGlassStairsBlock> deferredBlock : MoGlassBlocks.STAINED_GLASS_STAIRS) {
            event.accept(deferredBlock);
        }
        event.accept(MoGlassBlocks.GLASS_SLAB);
        event.accept(MoGlassBlocks.TINTED_GLASS_SLAB);
        for (DeferredBlock deferredBlock : MoGlassBlocks.STAINED_GLASS_SLABS) {
            event.accept((ItemLike)deferredBlock);
        }
    }
}

