/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.glass;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.wurstclient.glass.MoGlassBlocks;

public final class GlassStairsBlock
extends StairBlock {
    protected GlassStairsBlock(BlockBehaviour.Properties settings) {
        super(Blocks.GLASS.defaultBlockState(), settings);
    }

    public boolean skipRendering(BlockState state, BlockState stateFrom, Direction direction) {
        if (stateFrom.getBlock() == Blocks.GLASS) {
            return true;
        }
        if (stateFrom.getBlock() == MoGlassBlocks.GLASS_SLAB.get() && this.isInvisibleToGlassSlab(state, stateFrom, direction)) {
            return true;
        }
        if (stateFrom.getBlock() == this && this.isInvisibleToGlassStairs(state, stateFrom, direction)) {
            return true;
        }
        return super.skipRendering(state, stateFrom, direction);
    }

    private boolean isInvisibleToGlassSlab(BlockState state, BlockState stateFrom, Direction direction) {
        Half half = (Half)state.getValue((Property)StairBlock.HALF);
        Direction facing = (Direction)state.getValue((Property)StairBlock.FACING);
        StairsShape shape = (StairsShape)state.getValue((Property)StairBlock.SHAPE);
        SlabType typeFrom = (SlabType)stateFrom.getValue((Property)SlabBlock.TYPE);
        if (direction == Direction.UP && typeFrom != SlabType.TOP) {
            return true;
        }
        if (direction == Direction.DOWN && typeFrom != SlabType.BOTTOM) {
            return true;
        }
        if (typeFrom == SlabType.DOUBLE) {
            return true;
        }
        if (direction == facing.getOpposite()) {
            if (typeFrom == SlabType.BOTTOM && half == Half.BOTTOM) {
                return true;
            }
            if (typeFrom == SlabType.TOP && half == Half.TOP) {
                return true;
            }
        }
        if (direction == facing.getClockWise() && shape == StairsShape.OUTER_LEFT) {
            if (typeFrom == SlabType.BOTTOM && half == Half.BOTTOM) {
                return true;
            }
            if (typeFrom == SlabType.TOP && half == Half.TOP) {
                return true;
            }
        }
        if (direction == facing.getCounterClockWise() && shape == StairsShape.OUTER_RIGHT) {
            if (typeFrom == SlabType.BOTTOM && half == Half.BOTTOM) {
                return true;
            }
            if (typeFrom == SlabType.TOP && half == Half.TOP) {
                return true;
            }
        }
        return false;
    }

    private boolean isInvisibleToGlassStairs(BlockState state, BlockState stateFrom, Direction direction) {
        Half half = (Half)state.getValue((Property)StairBlock.HALF);
        Half halfFrom = (Half)stateFrom.getValue((Property)StairBlock.HALF);
        Direction facing = (Direction)state.getValue((Property)StairBlock.FACING);
        Direction facingFrom = (Direction)stateFrom.getValue((Property)StairBlock.FACING);
        StairsShape shape = (StairsShape)state.getValue((Property)StairBlock.SHAPE);
        StairsShape shapeFrom = (StairsShape)stateFrom.getValue((Property)StairBlock.SHAPE);
        if (direction == Direction.UP) {
            if (halfFrom == Half.BOTTOM) {
                return true;
            }
            if (half != halfFrom) {
                if (facing == facingFrom && shape == shapeFrom) {
                    return true;
                }
                switch (shape) {
                    case STRAIGHT: {
                        if (shapeFrom == StairsShape.INNER_LEFT && (facingFrom == facing || facingFrom == facing.getClockWise())) {
                            return true;
                        }
                        if (shapeFrom != StairsShape.INNER_RIGHT || facingFrom != facing && facingFrom != facing.getCounterClockWise()) break;
                        return true;
                    }
                    case INNER_LEFT: {
                        if (shapeFrom != StairsShape.INNER_RIGHT || facingFrom != facing.getCounterClockWise()) break;
                        return true;
                    }
                    case INNER_RIGHT: {
                        if (shapeFrom != StairsShape.INNER_LEFT || facingFrom != facing.getClockWise()) break;
                        return true;
                    }
                    case OUTER_LEFT: {
                        if (shapeFrom == StairsShape.OUTER_RIGHT && facingFrom == facing.getCounterClockWise()) {
                            return true;
                        }
                        if (shapeFrom != StairsShape.STRAIGHT || facingFrom != facing && facingFrom != facing.getCounterClockWise()) break;
                        return true;
                    }
                    case OUTER_RIGHT: {
                        if (shapeFrom == StairsShape.OUTER_LEFT && facingFrom == facing.getClockWise()) {
                            return true;
                        }
                        if (shapeFrom != StairsShape.STRAIGHT || facingFrom != facing && facingFrom != facing.getClockWise()) break;
                        return true;
                    }
                }
            }
        }
        if (direction == Direction.DOWN) {
            if (halfFrom == Half.TOP) {
                return true;
            }
            switch (shape) {
                case STRAIGHT: {
                    if (shapeFrom == StairsShape.INNER_LEFT && (facingFrom == facing || facingFrom == facing.getClockWise())) {
                        return true;
                    }
                    if (shapeFrom != StairsShape.INNER_RIGHT || facingFrom != facing && facingFrom != facing.getCounterClockWise()) break;
                    return true;
                }
                case INNER_LEFT: {
                    if (shapeFrom != StairsShape.INNER_RIGHT || facingFrom != facing.getCounterClockWise()) break;
                    return true;
                }
                case INNER_RIGHT: {
                    if (shapeFrom != StairsShape.INNER_LEFT || facingFrom != facing.getClockWise()) break;
                    return true;
                }
                case OUTER_LEFT: {
                    if (shapeFrom == StairsShape.OUTER_RIGHT && facingFrom == facing.getCounterClockWise()) {
                        return true;
                    }
                    if (shapeFrom != StairsShape.STRAIGHT || facingFrom != facing && facingFrom != facing.getCounterClockWise()) break;
                    return true;
                }
                case OUTER_RIGHT: {
                    if (shapeFrom == StairsShape.OUTER_LEFT && facingFrom == facing.getClockWise()) {
                        return true;
                    }
                    if (shapeFrom != StairsShape.STRAIGHT || facingFrom != facing && facingFrom != facing.getClockWise()) break;
                    return true;
                }
            }
        }
        if (facingFrom == direction.getOpposite() && shapeFrom != StairsShape.OUTER_LEFT && shapeFrom != StairsShape.OUTER_RIGHT) {
            return true;
        }
        if (facingFrom.getCounterClockWise() == direction && shapeFrom == StairsShape.INNER_RIGHT) {
            return true;
        }
        if (facingFrom.getClockWise() == direction && shapeFrom == StairsShape.INNER_LEFT) {
            return true;
        }
        if (direction == facing && half == halfFrom) {
            if (facingFrom == facing.getCounterClockWise() && shape == StairsShape.OUTER_LEFT && shapeFrom != StairsShape.OUTER_RIGHT) {
                return true;
            }
            if (facingFrom == facing.getClockWise() && shape == StairsShape.OUTER_RIGHT && shapeFrom != StairsShape.OUTER_LEFT) {
                return true;
            }
        }
        if (direction == facing.getOpposite() && half == halfFrom) {
            if (facingFrom == facing.getCounterClockWise() && shapeFrom != StairsShape.OUTER_LEFT) {
                return true;
            }
            if (facingFrom == facing.getClockWise() && shapeFrom != StairsShape.OUTER_RIGHT) {
                return true;
            }
            if (facingFrom == facing.getOpposite()) {
                return true;
            }
        }
        if (direction == facing.getCounterClockWise() && half == halfFrom) {
            if (facingFrom == direction && shape != StairsShape.INNER_LEFT && shapeFrom == StairsShape.INNER_RIGHT) {
                return true;
            }
            if (facingFrom == facing && shapeFrom != StairsShape.OUTER_LEFT) {
                return true;
            }
            if (facingFrom == facing.getClockWise() && shapeFrom == StairsShape.OUTER_LEFT && shape != StairsShape.INNER_LEFT) {
                return true;
            }
            if (facingFrom == facing.getOpposite() && shape == StairsShape.OUTER_RIGHT) {
                return true;
            }
        }
        if (direction == facing.getClockWise() && half == halfFrom) {
            if (facingFrom == direction && shape != StairsShape.INNER_RIGHT && shapeFrom == StairsShape.INNER_LEFT) {
                return true;
            }
            if (facingFrom == facing && shapeFrom != StairsShape.OUTER_RIGHT) {
                return true;
            }
            if (facingFrom == facing.getCounterClockWise() && shapeFrom == StairsShape.OUTER_RIGHT && shape != StairsShape.INNER_RIGHT) {
                return true;
            }
            if (facingFrom == facing.getOpposite() && shape == StairsShape.OUTER_LEFT) {
                return true;
            }
        }
        return false;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }
}

