/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks.full_belt;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltPart;
import com.simibubi.create.content.kinetics.belt.BeltRenderer;
import com.simibubi.create.content.kinetics.belt.BeltSlope;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import dev.lopyluna.dndecor.register.DnDecorBlocks;
import dev.lopyluna.dndecor.register.client.DnDecorPartialModels;
import dev.lopyluna.dndecor.register.client.DnDecorSpriteShifts;
import java.util.function.Supplier;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class FullBeltRenderer
extends BeltRenderer {
    public FullBeltRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(BeltBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            BlockState blockState = be.getBlockState();
            if (!DnDecorBlocks.BELT.has(blockState)) {
                return;
            }
            BeltSlope beltSlope = (BeltSlope)blockState.getValue(BeltBlock.SLOPE);
            BeltPart part = (BeltPart)blockState.getValue(BeltBlock.PART);
            Direction facing = (Direction)blockState.getValue(BeltBlock.HORIZONTAL_FACING);
            Direction.AxisDirection axisDirection = facing.getAxisDirection();
            boolean downward = beltSlope == BeltSlope.DOWNWARD;
            boolean upward = beltSlope == BeltSlope.UPWARD;
            boolean diagonal = downward || upward;
            boolean start = part == BeltPart.START;
            boolean end = part == BeltPart.END;
            boolean sideways = beltSlope == BeltSlope.SIDEWAYS;
            boolean alongX = facing.getAxis() == Direction.Axis.X;
            PoseStack localTransforms = new PoseStack();
            PoseTransformStack msr = TransformStack.of((PoseStack)localTransforms);
            VertexConsumer vb = buffer.getBuffer(RenderType.solid());
            float renderTick = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel());
            ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)msr.center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)facing) + (float)(upward ? 180 : 0) + (float)(sideways ? 270 : 0))).rotateZDegrees(sideways ? 90.0f : 0.0f)).rotateXDegrees(!diagonal && beltSlope != BeltSlope.HORIZONTAL ? 90.0f : 0.0f)).uncenter();
            if (downward || beltSlope == BeltSlope.VERTICAL && axisDirection == Direction.AxisDirection.POSITIVE) {
                boolean b = start;
                start = end;
                end = b;
            }
            DyeColor color = be.color.orElse(null);
            for (boolean bottom : Iterate.trueAndFalse) {
                PartialModel beltPartial = FullBeltRenderer.getBeltPartial(diagonal, start, end, bottom);
                SuperByteBuffer beltBuffer = CachedBuffers.partial((PartialModel)beltPartial, (BlockState)blockState).light(light);
                SpriteShiftEntry spriteShift = FullBeltRenderer.getSpriteShiftEntry(color, diagonal, bottom);
                float speed = be.getSpeed();
                if (speed != 0.0f || be.color.isPresent()) {
                    float time = renderTick * (float)axisDirection.getStep();
                    if (diagonal && downward ^ alongX || !sideways && !diagonal && alongX || sideways && axisDirection == Direction.AxisDirection.NEGATIVE) {
                        speed = -speed;
                    }
                    float scrollMulti = diagonal ? 0.375f : 0.5f;
                    float spriteSize = spriteShift.getTarget().getV1() - spriteShift.getTarget().getV0();
                    double scroll = (double)(speed * time) / 504.0 + (bottom ? 0.5 : 0.0);
                    scroll -= Math.floor(scroll);
                    scroll = scroll * (double)spriteSize * (double)scrollMulti;
                    beltBuffer.shiftUVScrolling(spriteShift, (float)scroll);
                }
                ((SuperByteBuffer)beltBuffer.transform(localTransforms)).renderInto(ms, vb);
                if (diagonal) break;
            }
            if (be.hasPulley()) {
                Direction dir = sideways ? Direction.UP : ((Direction)blockState.getValue(BeltBlock.HORIZONTAL_FACING)).getClockWise();
                Supplier<PoseStack> matrixStackSupplier = () -> {
                    PoseStack stack = new PoseStack();
                    PoseTransformStack stacker = TransformStack.of((PoseStack)stack);
                    stacker.center();
                    if (dir.getAxis() == Direction.Axis.X) {
                        stacker.rotateYDegrees(90.0f);
                    }
                    if (dir.getAxis() == Direction.Axis.Y) {
                        stacker.rotateXDegrees(90.0f);
                    }
                    stacker.rotateXDegrees(90.0f);
                    stacker.uncenter();
                    return stack;
                };
                SuperByteBuffer superBuffer = CachedBuffers.partialDirectional((PartialModel)AllPartialModels.BELT_PULLEY, (BlockState)blockState, (Direction)dir, matrixStackSupplier);
                KineticBlockEntityRenderer.standardKineticRotationTransform((SuperByteBuffer)superBuffer, (KineticBlockEntity)be, (int)light).renderInto(ms, vb);
            }
        }
        this.renderItems(be, partialTicks, ms, buffer, light, overlay);
    }

    public static SpriteShiftEntry getSpriteShiftEntry(DyeColor color, boolean diagonal, boolean bottom) {
        if (color != null) {
            return (diagonal ? DnDecorSpriteShifts.DYED_DIAGONAL_BELTS : (bottom ? DnDecorSpriteShifts.DYED_OFFSET_BELTS : DnDecorSpriteShifts.DYED_BELTS)).get(color);
        }
        return diagonal ? DnDecorSpriteShifts.BELT_DIAGONAL : (bottom ? DnDecorSpriteShifts.BELT_OFFSET : DnDecorSpriteShifts.BELT);
    }

    public static PartialModel getBeltPartial(boolean diagonal, boolean start, boolean end, boolean bottom) {
        if (diagonal) {
            if (start) {
                return DnDecorPartialModels.BELT_DIAGONAL_START;
            }
            if (end) {
                return DnDecorPartialModels.BELT_DIAGONAL_END;
            }
            return DnDecorPartialModels.BELT_DIAGONAL_MIDDLE;
        }
        if (bottom) {
            if (start) {
                return DnDecorPartialModels.BELT_START_BOTTOM;
            }
            if (end) {
                return DnDecorPartialModels.BELT_END_BOTTOM;
            }
            return DnDecorPartialModels.BELT_MIDDLE_BOTTOM;
        }
        if (start) {
            return DnDecorPartialModels.BELT_START;
        }
        if (end) {
            return DnDecorPartialModels.BELT_END;
        }
        return DnDecorPartialModels.BELT_MIDDLE;
    }
}

