/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks.full_belt;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.BeltPart;
import com.simibubi.create.content.kinetics.belt.BeltSlicer;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import dev.lopyluna.dndecor.content.blocks.full_belt.FullBeltSlicer;
import dev.lopyluna.dndecor.register.DnDecorBETypes;
import dev.lopyluna.dndecor.register.DnDecorItems;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;

public class FullBeltBlock
extends BeltBlock {
    public FullBeltBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        SoundType soundType;
        boolean isHand;
        if (player.isShiftKeyDown() || !player.mayBuild()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        boolean isWrench = AllItems.WRENCH.isIn(stack);
        boolean isConnector = DnDecorItems.BELT_CONNECTOR.isIn(stack);
        boolean isShaft = AllBlocks.SHAFT.isIn(stack);
        boolean isDye = stack.is(Tags.Items.DYES);
        boolean hasWater = ((FluidStack)GenericItemEmptying.emptyItem((Level)level, (ItemStack)stack, (boolean)true).getFirst()).getFluid().isSame((Fluid)Fluids.WATER);
        boolean bl = isHand = stack.isEmpty() && hand == InteractionHand.MAIN_HAND;
        if (isDye || hasWater) {
            return this.onBlockEntityUseItemOn((BlockGetter)level, pos, be -> be.applyColor(DyeColor.getColor((ItemStack)stack)) ? ItemInteractionResult.SUCCESS : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION);
        }
        if (isConnector) {
            return FullBeltSlicer.useConnector(state, level, pos, player, hand, hitResult, new BeltSlicer.Feedback());
        }
        if (isWrench) {
            return FullBeltSlicer.useWrench(state, level, pos, player, hand, hitResult, new BeltSlicer.Feedback());
        }
        BeltBlockEntity belt = BeltHelper.getSegmentBE((LevelAccessor)level, (BlockPos)pos);
        if (belt == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (PackageItem.isPackage((ItemStack)stack)) {
            ItemStack toInsert = stack.copy();
            IItemHandler handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, belt.getBlockPos(), null);
            if (handler == null) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            ItemStack remainder = handler.insertItem(0, toInsert, false);
            if (remainder.isEmpty()) {
                stack.shrink(1);
                return ItemInteractionResult.SUCCESS;
            }
        }
        if (isHand) {
            BeltBlockEntity controllerBelt = belt.getControllerBE();
            if (controllerBelt == null) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (level.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            MutableBoolean success = new MutableBoolean(false);
            controllerBelt.getInventory().applyToEachWithin((float)belt.index + 0.5f, 0.55f, transportedItemStack -> {
                player.getInventory().placeItemBackInInventory(transportedItemStack.stack);
                success.setTrue();
                return TransportedItemStackHandlerBehaviour.TransportedResult.removeItem();
            });
            if (success.isTrue()) {
                level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, 1.0f + level.random.nextFloat());
            }
        }
        if (isShaft) {
            if (state.getValue(PART) != BeltPart.MIDDLE) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (level.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)((BlockState)state.setValue(PART, (Comparable)BeltPart.PULLEY)));
            return ItemInteractionResult.SUCCESS;
        }
        if (AllBlocks.BRASS_CASING.isIn(stack)) {
            this.withBlockEntityDo((BlockGetter)level, pos, be -> be.setCasingType(BeltBlockEntity.CasingType.BRASS));
            this.updateCoverProperty((LevelAccessor)level, pos, level.getBlockState(pos));
            soundType = AllBlocks.BRASS_CASING.getDefaultState().getSoundType((LevelReader)level, pos, (Entity)player);
            level.playSound(null, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
            return ItemInteractionResult.SUCCESS;
        }
        if (AllBlocks.ANDESITE_CASING.isIn(stack)) {
            this.withBlockEntityDo((BlockGetter)level, pos, be -> be.setCasingType(BeltBlockEntity.CasingType.ANDESITE));
            this.updateCoverProperty((LevelAccessor)level, pos, level.getBlockState(pos));
            soundType = AllBlocks.ANDESITE_CASING.getDefaultState().getSoundType((LevelReader)level, pos, (Entity)player);
            level.playSound(null, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity be) {
        ArrayList<ItemStack> required = new ArrayList<ItemStack>();
        if (state.getValue(PART) != BeltPart.MIDDLE) {
            required.add(AllBlocks.SHAFT.asStack());
        }
        if (state.getValue(PART) == BeltPart.START) {
            required.add(DnDecorItems.BELT_CONNECTOR.asStack());
        }
        if (required.isEmpty()) {
            return ItemRequirement.NONE;
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, required);
    }

    @NotNull
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return DnDecorItems.BELT_CONNECTOR.asStack();
    }

    public BlockEntityType<? extends BeltBlockEntity> getBlockEntityType() {
        return (BlockEntityType)DnDecorBETypes.BELT.get();
    }
}

