/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateDataProvider;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import dev.lopyluna.dndecor.DnDecor;
import dev.lopyluna.dndecor.content.datagen.DatagenTags;
import dev.lopyluna.dndecor.content.datagen.ProcessingDnDecorRecipeGen;
import dev.lopyluna.dndecor.content.datagen.recipes.MechanicalCraftingGen;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class DnDecorDatagen {
    public static void gatherData(GatherDataEvent event) {
        DnDecorDatagen.addExtraRegistrateData();
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new MechanicalCraftingGen(output, lookupProvider));
        event.getGenerator().addProvider(true, (DataProvider)DnDecor.REGISTRATE.setDataProvider(new RegistrateDataProvider((AbstractRegistrate)DnDecor.REGISTRATE, "dndecor", event)));
        if (event.includeServer()) {
            ProcessingDnDecorRecipeGen.registerAll(generator, output, lookupProvider);
        }
    }

    private static void addExtraRegistrateData() {
        DatagenTags.addGenerators();
        DnDecor.REGISTRATE.addDataGenerator(ProviderType.LANG, provider -> {
            BiConsumer<String, String> langConsumer = (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1);
            DnDecorDatagen.provideDefaultLang("tooltips", langConsumer);
        });
    }

    private static void provideDefaultLang(String fileName, BiConsumer<String, String> consumer) {
        String path = "assets/dndecor/lang/default/" + fileName + ".json";
        JsonElement jsonElement = FilesHelper.loadJsonResource((String)path);
        if (jsonElement == null) {
            throw new IllegalStateException(String.format("Could not find default lang file: %s", path));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            consumer.accept(key, value);
        }
    }
}

