/*
 * Decompiled with CFR 0.152.
 */
package jeresources.entry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import jeresources.api.conditionals.LightLevel;
import jeresources.api.drop.LootDrop;
import jeresources.compatibility.minecraft.ExperienceRange;
import jeresources.compatibility.minecraft.MobCompat;
import jeresources.util.LootTableHelper;
import jeresources.util.MobHelper;
import jeresources.util.TranslationHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.Nullable;

public class MobEntry {
    private static final List<String> ANY_BIOMES = List.of("jer.any");
    private final List<String> biomes;
    private final Supplier<LivingEntity> entitySupplier;
    @Nullable
    private LivingEntity entity;
    @Nullable
    private LightLevel lightLevel;
    @Nullable
    private ExperienceRange experience;
    private List<LootDrop> drops;

    private static List<String> distinctBiomes(String ... biomes) {
        return Arrays.stream(biomes).distinct().toList();
    }

    private static List<LootDrop> distinctDrops(LootDrop ... drops) {
        return MobEntry.distinctDrops(Arrays.stream(drops));
    }

    private static List<LootDrop> distinctDrops(Stream<LootDrop> dropsStream) {
        Set seen = Collections.newSetFromMap(new IdentityHashMap());
        return dropsStream.filter(drop -> drop != null && drop.item != null && seen.add(drop.item.getItem())).toList();
    }

    public static MobEntry create(Supplier<LivingEntity> entity, LightLevel lightLevel, int minExp, int maxExp, String[] biomes, LootDrop ... drops) {
        return new MobEntry(entity, lightLevel, new ExperienceRange(minExp, maxExp), MobEntry.distinctBiomes(biomes), MobEntry.distinctDrops(drops));
    }

    public static MobEntry create(Supplier<LivingEntity> entity, LightLevel lightLevel, String[] biomes, LootDrop ... drops) {
        return new MobEntry(entity, lightLevel, null, MobEntry.distinctBiomes(biomes), MobEntry.distinctDrops(drops));
    }

    public static MobEntry create(Supplier<LivingEntity> entity, LightLevel lightLevel, int exp, String[] biomes, LootDrop ... drops) {
        return new MobEntry(entity, lightLevel, new ExperienceRange(exp, exp), MobEntry.distinctBiomes(biomes), MobEntry.distinctDrops(drops));
    }

    public static MobEntry create(Supplier<LivingEntity> entity, LightLevel lightLevel, int exp, LootDrop ... drops) {
        return new MobEntry(entity, lightLevel, new ExperienceRange(exp, exp), ANY_BIOMES, MobEntry.distinctDrops(drops));
    }

    public static MobEntry create(Supplier<LivingEntity> entity, LightLevel lightLevel, int minExp, int maxExp, LootDrop ... drops) {
        return new MobEntry(entity, lightLevel, new ExperienceRange(minExp, maxExp), ANY_BIOMES, MobEntry.distinctDrops(drops));
    }

    public static MobEntry create(Supplier<LivingEntity> entity, LightLevel lightLevel, LootDrop ... drops) {
        return new MobEntry(entity, lightLevel, null, ANY_BIOMES, MobEntry.distinctDrops(drops));
    }

    public static MobEntry create(Supplier<LivingEntity> entity, LootDrop ... drops) {
        return new MobEntry(entity, null, null, ANY_BIOMES, MobEntry.distinctDrops(drops));
    }

    public static MobEntry create(Supplier<LivingEntity> entity, LootTable lootTable) {
        List<LootDrop> drops = LootTableHelper.toDrops(lootTable);
        return new MobEntry(entity, null, null, ANY_BIOMES, drops);
    }

    public static MobEntry create(Supplier<LivingEntity> entity) {
        ArrayList<LootDrop> drops = new ArrayList<LootDrop>();
        return new MobEntry(entity, null, null, ANY_BIOMES, drops);
    }

    private MobEntry(Supplier<LivingEntity> entitySupplier, @Nullable LightLevel lightLevel, @Nullable ExperienceRange experience, List<String> biomes, List<LootDrop> drops) {
        this.entitySupplier = entitySupplier;
        this.entity = null;
        this.lightLevel = lightLevel;
        this.biomes = biomes;
        this.drops = drops;
        this.experience = experience;
    }

    public LivingEntity getEntity() {
        if (this.entity == null) {
            this.entity = this.entitySupplier.get();
        }
        return this.entity;
    }

    public String getMobName() {
        LivingEntity entity = this.getEntity();
        return MobHelper.getExpandedName(entity);
    }

    public List<LootDrop> getDrops() {
        return this.drops;
    }

    public List<ItemStack> getDropsItemStacks() {
        return this.drops.stream().map(LootDrop::getDrops).flatMap(Collection::stream).toList();
    }

    public boolean hasMultipleBiomes() {
        return this.biomes.size() > 1;
    }

    public Stream<String> getTranslatedBiomes() {
        return this.biomes.stream().map(x$0 -> TranslationHelper.translateAndFormat(x$0, new Object[0]));
    }

    public void setDrops(Collection<LootDrop> drops) {
        this.drops = MobEntry.distinctDrops(drops.stream());
    }

    public LightLevel getLightLevel() {
        if (this.lightLevel == null) {
            LivingEntity entity = this.getEntity();
            this.lightLevel = MobCompat.getLightLevel((Entity)entity);
        }
        return this.lightLevel;
    }

    public String getExp() {
        if (this.experience == null) {
            LivingEntity entity = this.getEntity();
            this.experience = MobCompat.getExperience(entity);
        }
        return this.experience.getExpString();
    }

    public boolean hasSpawnEgg() {
        return this.getSpawnEgg() != null;
    }

    public ItemStack getSpawnEgg() {
        return this.getEntity().getPickResult();
    }
}

