/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.createstuffadditions.procedures;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.mcreator.createstuffadditions.init.CreateSaModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@EventBusSubscriber(value={Dist.CLIENT})
public class GrapplinWhiskChainsLineProcedure {
    private static RenderLevelStageEvent provider = null;
    private static Map<EntityType, Entity> data = new HashMap<EntityType, Entity>();

    public static void renderBackground(String texts, double x, double y, double z, float yaw, float pitch, float roll, float scale, int color) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        Vec3 pos = provider.getCamera().getPosition();
        PoseStack poseStack = provider.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(x - pos.x(), y - pos.y(), z - pos.z());
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(scale, -scale, 1.0f);
        float f = (float)(font.width(texts) - 1) * -0.5f;
        Objects.requireNonNull(font);
        poseStack.translate(f, (float)(9 - 1) * -0.5f, 0.0f);
        Matrix4f matrix4f = poseStack.last().pose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        font.drawInBatch(texts, 0.0f, 0.0f, 0, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, color, 0xF000F0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    public static void renderBlock(BlockState blockState, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        BlockPos blockPos = BlockPos.containing((double)x, (double)y, (double)z);
        Vec3 pos = provider.getCamera().getPosition();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.getLightColor((BlockAndTintGetter)Minecraft.getInstance().level, (BlockPos)blockPos);
        PoseStack poseStack = provider.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(x - pos.x(), y - pos.y(), z - pos.z());
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(scale, scale, scale);
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GrapplinWhiskChainsLineProcedure.renderBlockModel(blockState, blockPos, poseStack, packedLight);
        GrapplinWhiskChainsLineProcedure.renderBlockEntity(blockState, blockPos, poseStack, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    private static void renderBlockEntity(BlockState blockState, BlockPos blockPos, PoseStack poseStack, int packedLight) {
        Block block = blockState.getBlock();
        if (block instanceof EntityBlock) {
            BlockEntityRenderer blockEntityRenderer;
            EntityBlock entityBlock = (EntityBlock)block;
            Minecraft minecraft = Minecraft.getInstance();
            ClientLevel level = minecraft.level;
            BlockEntity blockEntity = entityBlock.newBlockEntity(blockPos, blockState);
            if (blockEntity != null && (blockEntityRenderer = minecraft.getBlockEntityRenderDispatcher().getRenderer(blockEntity)) != null) {
                MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
                blockEntity.setLevel((Level)level);
                blockEntityRenderer.render(blockEntity, 0.0f, poseStack, (MultiBufferSource)bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
            }
        }
    }

    private static void renderBlockModel(BlockState blockState, BlockPos blockPos, PoseStack poseStack, int packedLight) {
        if (blockState.getRenderShape() == RenderShape.MODEL) {
            Minecraft minecraft = Minecraft.getInstance();
            ClientLevel level = minecraft.level;
            MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
            BlockRenderDispatcher dispatcher = minecraft.getBlockRenderer();
            ModelBlockRenderer renderer = dispatcher.getModelRenderer();
            BakedModel bakedModel = dispatcher.getBlockModel(blockState);
            ModelData modelData = bakedModel.getModelData((BlockAndTintGetter)level, blockPos, blockState, ModelData.builder().build());
            PoseStack.Pose pose = poseStack.last();
            int color = minecraft.getBlockColors().getColor(blockState, (Level)level, blockPos);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            for (RenderType renderType : bakedModel.getRenderTypes(blockState, RandomSource.create((long)42L), modelData)) {
                renderer.renderModel(pose, bufferSource.getBuffer(Sheets.translucentCullBlockSheet()), blockState, bakedModel, red, green, blue, packedLight, OverlayTexture.NO_OVERLAY, modelData, renderType);
            }
        }
    }

    public static void renderEntity(EntityType type, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        Entity entity;
        if (type == null) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (data.containsKey(type)) {
            entity = data.get(type);
            if (entity.level() != level) {
                entity = type.create((Level)level);
                data.put(type, entity);
            }
        } else {
            entity = type.create((Level)level);
            data.put(type, entity);
        }
        GrapplinWhiskChainsLineProcedure.renderEntity(entity, 0.0f, x, y, z, yaw, pitch, roll, scale, glowing ? 0xF000F0 : LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)BlockPos.containing((double)x, (double)y, (double)z)));
    }

    public static void renderEntity(Entity entity, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        float partialTick = provider.getPartialTick().getGameTimeDeltaPartialTick(false);
        int packedLight = glowing ? 0xF000F0 : Minecraft.getInstance().getEntityRenderDispatcher().getPackedLightCoords(entity, partialTick);
        GrapplinWhiskChainsLineProcedure.renderEntity(entity, partialTick, x, y, z, yaw, pitch, roll, scale, packedLight);
    }

    private static void renderEntity(Entity entity, float partialTick, double x, double y, double z, float yaw, float pitch, float roll, float scale, int packedLight) {
        if (entity == null) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        EntityRenderer renderer = minecraft.getEntityRenderDispatcher().getRenderer(entity);
        Vec3 pos = provider.getCamera().getPosition();
        float offset = entity.getBbHeight() / 2.0f * scale;
        PoseStack poseStack = provider.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(x - pos.x(), y + (double)offset - pos.y(), z - pos.z());
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.translate(0.0f, -offset, 0.0f);
        poseStack.scale(scale, scale, scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderer.render(entity, entity.getViewYRot(partialTick), partialTick, poseStack, (MultiBufferSource)bufferSource, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    public static void renderItem(ItemStack itemStack, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean flipping, boolean glowing) {
        Minecraft minecraft = Minecraft.getInstance();
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        ItemRenderer renderer = minecraft.getItemRenderer();
        Vec3 pos = provider.getCamera().getPosition();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.getLightColor((BlockAndTintGetter)minecraft.level, (BlockPos)BlockPos.containing((double)x, (double)y, (double)z));
        PoseStack poseStack = provider.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(x - pos.x(), y - pos.y(), z - pos.z());
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(scale, scale, scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderer.renderStatic(null, itemStack, ItemDisplayContext.FIXED, flipping, poseStack, (MultiBufferSource)bufferSource, (Level)minecraft.level, packedLight, OverlayTexture.NO_OVERLAY, 0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    public static void renderLine(double x1, double y1, double z1, double x2, double y2, double z2, int color) {
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        Vec3 pos = provider.getCamera().getPosition();
        Vector3f normal = new Vec3(x2 - x1, y2 - y1, z2 - z1).normalize().toVector3f();
        Matrix4f matrix4f = provider.getPoseStack().last().pose();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.lines());
        vertexConsumer.addVertex(matrix4f, (float)(x1 - pos.x()), (float)(y1 - pos.y()), (float)(z1 - pos.z())).setColor(color).setNormal(normal.x(), normal.y(), normal.z());
        vertexConsumer.addVertex(matrix4f, (float)(x2 - pos.x()), (float)(y2 - pos.y()), (float)(z2 - pos.z())).setColor(color).setNormal(normal.x(), normal.y(), normal.z());
    }

    public static void renderTexts(String texts, double x, double y, double z, float yaw, float pitch, float roll, float scale, int color, boolean glowing) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        Vec3 pos = provider.getCamera().getPosition();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.getLightColor((BlockAndTintGetter)minecraft.level, (BlockPos)BlockPos.containing((double)x, (double)y, (double)z));
        PoseStack poseStack = provider.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(x - pos.x(), y - pos.y(), z - pos.z());
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(scale, -scale, 1.0f);
        float f = (float)(font.width(texts) - 1) * -0.5f;
        Objects.requireNonNull(font);
        poseStack.translate(f, (float)(9 - 1) * -0.5f, 0.0f);
        Matrix4f matrix4f = poseStack.last().pose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        font.drawInBatch(texts, 0.0f, 0.0f, color, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void renderModels(RenderLevelStageEvent event) {
        provider = event;
        if (provider.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            ClientLevel level = Minecraft.getInstance().level;
            Entity entity = provider.getCamera().getEntity();
            Vec3 pos = entity.getPosition(provider.getPartialTick().getGameTimeDeltaPartialTick(false));
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            GrapplinWhiskChainsLineProcedure.execute((Event)provider, (LevelAccessor)level, provider.getPartialTick().getGameTimeDeltaPartialTick(false));
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
        }
    }

    public static void execute(LevelAccessor world, double partialTick) {
        GrapplinWhiskChainsLineProcedure.execute(null, world, partialTick);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double partialTick) {
        block81: {
            ItemStack lcl_chains = ItemStack.EMPTY;
            ItemStack back_sword = ItemStack.EMPTY;
            double nb = 0.0;
            double lcl_distance = 0.0;
            double dx = 0.0;
            double dy = 0.0;
            double dz = 0.0;
            double playerPosX = 0.0;
            double playerPosY = 0.0;
            double playerPosZ = 0.0;
            double yaw_rad = 0.0;
            double raytraceZ = 0.0;
            double raytraceX = 0.0;
            double lateralComponent = 0.0;
            double deltaY = 0.0;
            if (!(world instanceof ClientLevel)) break block81;
            for (Entity entityiterator : ((ClientLevel)world).entitiesForRendering()) {
                ItemStack itemStack;
                ItemStack itemStack2;
                ItemStack itemStack3;
                ItemStack itemStack4;
                ItemStack itemStack5;
                ItemStack itemStack6;
                ItemStack itemStack7;
                ItemStack itemStack8;
                ItemStack itemStack9;
                ItemStack itemStack10;
                ItemStack itemStack11;
                ItemStack itemStack12;
                LivingEntity _livEnt;
                LivingEntity _livEnt2;
                ItemStack itemStack13;
                LivingEntity _livEnt3;
                LivingEntity _livEnt4;
                block83: {
                    block82: {
                        ItemStack itemStack14;
                        ItemStack itemStack15;
                        if (entityiterator instanceof LivingEntity) {
                            _livEnt4 = (LivingEntity)entityiterator;
                            itemStack15 = _livEnt4.getMainHandItem();
                        } else {
                            itemStack15 = ItemStack.EMPTY;
                        }
                        if (itemStack15.getItem() == CreateSaModItems.GRAPPLIN_WHISK.get()) break block82;
                        if (entityiterator instanceof LivingEntity) {
                            _livEnt3 = (LivingEntity)entityiterator;
                            itemStack14 = _livEnt3.getOffhandItem();
                        } else {
                            itemStack14 = ItemStack.EMPTY;
                        }
                        if (itemStack14.getItem() != CreateSaModItems.GRAPPLIN_WHISK.get()) break block83;
                    }
                    playerPosX = entityiterator.getPosition((float)partialTick).x() + entityiterator.getViewVector((float)partialTick).x() * 1.25;
                    playerPosY = (double)entityiterator.getBbHeight() * 0.75 + entityiterator.getPosition((float)partialTick).y() + entityiterator.getViewVector((float)partialTick).y() * 1.25;
                    playerPosZ = entityiterator.getPosition((float)partialTick).z() + entityiterator.getViewVector((float)partialTick).z() * 1.25;
                }
                if (entityiterator instanceof LivingEntity) {
                    _livEnt4 = (LivingEntity)entityiterator;
                    itemStack13 = _livEnt4.getMainHandItem();
                } else {
                    itemStack13 = ItemStack.EMPTY;
                }
                if (itemStack13.getItem() == CreateSaModItems.GRAPPLIN_WHISK.get()) {
                    ItemStack itemStack16;
                    if (entityiterator instanceof LivingEntity) {
                        _livEnt3 = (LivingEntity)entityiterator;
                        itemStack16 = _livEnt3.getMainHandItem();
                    } else {
                        itemStack16 = ItemStack.EMPTY;
                    }
                    if (((CustomData)itemStack16.copy().getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getBoolean("tagHooked")) {
                        ItemStack itemStack17;
                        ItemStack itemStack18;
                        ItemStack itemStack19;
                        if (entityiterator instanceof LivingEntity) {
                            LivingEntity _livEnt5 = (LivingEntity)entityiterator;
                            itemStack19 = _livEnt5.getMainHandItem();
                        } else {
                            itemStack19 = ItemStack.EMPTY;
                        }
                        double d = ((CustomData)itemStack19.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("xPostion");
                        if (entityiterator instanceof LivingEntity) {
                            LivingEntity _livEnt6 = (LivingEntity)entityiterator;
                            itemStack18 = _livEnt6.getMainHandItem();
                        } else {
                            itemStack18 = ItemStack.EMPTY;
                        }
                        double d2 = ((CustomData)itemStack18.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("yPostion");
                        if (entityiterator instanceof LivingEntity) {
                            LivingEntity _livEnt7 = (LivingEntity)entityiterator;
                            itemStack17 = _livEnt7.getMainHandItem();
                        } else {
                            itemStack17 = ItemStack.EMPTY;
                        }
                        if (!world.isEmptyBlock(BlockPos.containing((double)d, (double)d2, (double)((CustomData)itemStack17.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("zPostion")))) {
                            ItemStack itemStack20;
                            if (entityiterator instanceof LivingEntity) {
                                LivingEntity _livEnt8 = (LivingEntity)entityiterator;
                                itemStack20 = _livEnt8.getMainHandItem();
                            } else {
                                itemStack20 = ItemStack.EMPTY;
                            }
                            if (((CustomData)itemStack20.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") > 0.0) {
                                ItemStack itemStack21;
                                ItemStack itemStack22;
                                ItemStack itemStack23;
                                ItemStack itemStack24;
                                LivingEntity _livEnt9;
                                ItemStack itemStack25;
                                ItemStack itemStack26;
                                if (entityiterator instanceof LivingEntity) {
                                    _livEnt2 = (LivingEntity)entityiterator;
                                    itemStack26 = _livEnt2.getMainHandItem();
                                } else {
                                    itemStack26 = ItemStack.EMPTY;
                                }
                                double d3 = Math.pow(playerPosX - (((CustomData)itemStack26.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("xPostion") + 0.5), 2.0);
                                if (entityiterator instanceof LivingEntity) {
                                    _livEnt = (LivingEntity)entityiterator;
                                    itemStack25 = _livEnt.getMainHandItem();
                                } else {
                                    itemStack25 = ItemStack.EMPTY;
                                }
                                double d4 = d3 + Math.pow(playerPosY - (((CustomData)itemStack25.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("yPostion") + 0.5), 2.0);
                                if (entityiterator instanceof LivingEntity) {
                                    _livEnt9 = (LivingEntity)entityiterator;
                                    itemStack24 = _livEnt9.getMainHandItem();
                                } else {
                                    itemStack24 = ItemStack.EMPTY;
                                }
                                lcl_distance = Math.sqrt(d4 + Math.pow(playerPosZ - (((CustomData)itemStack24.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("zPostion") + 0.5), 2.0));
                                if (entityiterator instanceof LivingEntity) {
                                    _livEnt9 = (LivingEntity)entityiterator;
                                    itemStack23 = _livEnt9.getMainHandItem();
                                } else {
                                    itemStack23 = ItemStack.EMPTY;
                                }
                                dx = ((CustomData)itemStack23.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("xPostion") + 0.5 - playerPosX;
                                if (entityiterator instanceof LivingEntity) {
                                    _livEnt9 = (LivingEntity)entityiterator;
                                    itemStack22 = _livEnt9.getMainHandItem();
                                } else {
                                    itemStack22 = ItemStack.EMPTY;
                                }
                                dy = ((CustomData)itemStack22.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("yPostion") + 0.5 - playerPosY;
                                if (entityiterator instanceof LivingEntity) {
                                    _livEnt9 = (LivingEntity)entityiterator;
                                    itemStack21 = _livEnt9.getMainHandItem();
                                } else {
                                    itemStack21 = ItemStack.EMPTY;
                                }
                                dz = ((CustomData)itemStack21.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("zPostion") + 0.5 - playerPosZ;
                                nb = 0.0;
                                for (int index0 = 0; index0 < (int)(Math.ceil(lcl_distance) * 2.0); ++index0) {
                                    ItemStack itemStack27;
                                    ItemStack itemStack28;
                                    ItemStack itemStack29;
                                    ItemStack itemStack30;
                                    lcl_chains = new ItemStack((ItemLike)CreateSaModItems.CHAINS.get()).copy();
                                    if (entityiterator instanceof LivingEntity) {
                                        _livEnt = (LivingEntity)entityiterator;
                                        itemStack30 = _livEnt.getMainHandItem();
                                    } else {
                                        itemStack30 = ItemStack.EMPTY;
                                    }
                                    if (itemStack30.isEnchanted()) {
                                        lcl_chains.enchant((Holder)world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.parse((String)"create_sa:impact"))), 1);
                                    }
                                    if (entityiterator instanceof LivingEntity) {
                                        _livEnt = (LivingEntity)entityiterator;
                                        itemStack29 = _livEnt.getMainHandItem();
                                    } else {
                                        itemStack29 = ItemStack.EMPTY;
                                    }
                                    double d5 = playerPosX + (playerPosX - (((CustomData)itemStack29.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("xPostion") + 0.5)) / (lcl_distance == 0.0 ? 0.01 : lcl_distance) * nb * -1.0;
                                    if (entityiterator instanceof LivingEntity) {
                                        _livEnt = (LivingEntity)entityiterator;
                                        itemStack28 = _livEnt.getMainHandItem();
                                    } else {
                                        itemStack28 = ItemStack.EMPTY;
                                    }
                                    double d6 = playerPosY + (playerPosY - (((CustomData)itemStack28.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("yPostion") + 0.5)) / (lcl_distance == 0.0 ? 0.01 : lcl_distance) * nb * -1.0;
                                    if (entityiterator instanceof LivingEntity) {
                                        _livEnt = (LivingEntity)entityiterator;
                                        itemStack27 = _livEnt.getMainHandItem();
                                    } else {
                                        itemStack27 = ItemStack.EMPTY;
                                    }
                                    GrapplinWhiskChainsLineProcedure.renderItem(lcl_chains, d5, d6, playerPosZ + (playerPosZ - (((CustomData)itemStack27.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("zPostion") + 0.5)) / (lcl_distance == 0.0 ? 0.01 : lcl_distance) * nb * -1.0, (float)(Math.atan2(dx, dz) * -57.29577951308232 + 180.0), (float)(Math.atan2(dy, Math.abs(dx) + Math.abs(dz)) * 57.29577951308232), 0.0f, 1.0f, false, false);
                                    nb += 0.5;
                                }
                                continue;
                            }
                        }
                    }
                }
                if (entityiterator instanceof LivingEntity) {
                    LivingEntity _livEnt10 = (LivingEntity)entityiterator;
                    itemStack12 = _livEnt10.getOffhandItem();
                } else {
                    itemStack12 = ItemStack.EMPTY;
                }
                if (itemStack12.getItem() != CreateSaModItems.GRAPPLIN_WHISK.get()) continue;
                if (entityiterator instanceof LivingEntity) {
                    LivingEntity _livEnt11 = (LivingEntity)entityiterator;
                    itemStack11 = _livEnt11.getOffhandItem();
                } else {
                    itemStack11 = ItemStack.EMPTY;
                }
                if (!((CustomData)itemStack11.copy().getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getBoolean("tagHooked")) continue;
                if (entityiterator instanceof LivingEntity) {
                    LivingEntity _livEnt12 = (LivingEntity)entityiterator;
                    itemStack10 = _livEnt12.getOffhandItem();
                } else {
                    itemStack10 = ItemStack.EMPTY;
                }
                double d = ((CustomData)itemStack10.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("xPostion");
                if (entityiterator instanceof LivingEntity) {
                    LivingEntity _livEnt13 = (LivingEntity)entityiterator;
                    itemStack9 = _livEnt13.getOffhandItem();
                } else {
                    itemStack9 = ItemStack.EMPTY;
                }
                double d7 = ((CustomData)itemStack9.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("yPostion");
                if (entityiterator instanceof LivingEntity) {
                    LivingEntity _livEnt14 = (LivingEntity)entityiterator;
                    itemStack8 = _livEnt14.getOffhandItem();
                } else {
                    itemStack8 = ItemStack.EMPTY;
                }
                if (world.isEmptyBlock(BlockPos.containing((double)d, (double)d7, (double)((CustomData)itemStack8.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("zPostion")))) continue;
                if (entityiterator instanceof LivingEntity) {
                    LivingEntity _livEnt15 = (LivingEntity)entityiterator;
                    itemStack7 = _livEnt15.getOffhandItem();
                } else {
                    itemStack7 = ItemStack.EMPTY;
                }
                if (!(((CustomData)itemStack7.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") > 0.0)) continue;
                if (entityiterator instanceof LivingEntity) {
                    _livEnt2 = (LivingEntity)entityiterator;
                    itemStack6 = _livEnt2.getOffhandItem();
                } else {
                    itemStack6 = ItemStack.EMPTY;
                }
                double d8 = Math.pow(playerPosX - (((CustomData)itemStack6.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("xPostion") + 0.5), 2.0);
                if (entityiterator instanceof LivingEntity) {
                    _livEnt = (LivingEntity)entityiterator;
                    itemStack5 = _livEnt.getOffhandItem();
                } else {
                    itemStack5 = ItemStack.EMPTY;
                }
                double d9 = d8 + Math.pow(playerPosY - (((CustomData)itemStack5.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("yPostion") + 0.5), 2.0);
                if (entityiterator instanceof LivingEntity) {
                    LivingEntity _livEnt16 = (LivingEntity)entityiterator;
                    itemStack4 = _livEnt16.getOffhandItem();
                } else {
                    itemStack4 = ItemStack.EMPTY;
                }
                lcl_distance = Math.sqrt(d9 + Math.pow(playerPosZ - (((CustomData)itemStack4.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("zPostion") + 0.5), 2.0));
                if (entityiterator instanceof LivingEntity) {
                    LivingEntity _livEnt17 = (LivingEntity)entityiterator;
                    itemStack3 = _livEnt17.getOffhandItem();
                } else {
                    itemStack3 = ItemStack.EMPTY;
                }
                dx = ((CustomData)itemStack3.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("xPostion") + 0.5 - playerPosX;
                if (entityiterator instanceof LivingEntity) {
                    LivingEntity _livEnt18 = (LivingEntity)entityiterator;
                    itemStack2 = _livEnt18.getOffhandItem();
                } else {
                    itemStack2 = ItemStack.EMPTY;
                }
                dy = ((CustomData)itemStack2.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("yPostion") + 0.5 - playerPosY;
                if (entityiterator instanceof LivingEntity) {
                    LivingEntity _livEnt19 = (LivingEntity)entityiterator;
                    itemStack = _livEnt19.getOffhandItem();
                } else {
                    itemStack = ItemStack.EMPTY;
                }
                dz = ((CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("zPostion") + 0.5 - playerPosZ;
                nb = 0.0;
                for (int index1 = 0; index1 < (int)(Math.ceil(lcl_distance) * 2.0); ++index1) {
                    ItemStack itemStack31;
                    ItemStack itemStack32;
                    ItemStack itemStack33;
                    ItemStack itemStack34;
                    lcl_chains = new ItemStack((ItemLike)CreateSaModItems.CHAINS.get()).copy();
                    if (entityiterator instanceof LivingEntity) {
                        _livEnt = (LivingEntity)entityiterator;
                        itemStack34 = _livEnt.getOffhandItem();
                    } else {
                        itemStack34 = ItemStack.EMPTY;
                    }
                    if (itemStack34.isEnchanted()) {
                        lcl_chains.enchant((Holder)world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.parse((String)"create_sa:impact"))), 1);
                    }
                    if (entityiterator instanceof LivingEntity) {
                        _livEnt = (LivingEntity)entityiterator;
                        itemStack33 = _livEnt.getOffhandItem();
                    } else {
                        itemStack33 = ItemStack.EMPTY;
                    }
                    double d10 = playerPosX + (playerPosX - (((CustomData)itemStack33.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("xPostion") + 0.5)) / (lcl_distance == 0.0 ? 0.01 : lcl_distance) * nb * -1.0;
                    if (entityiterator instanceof LivingEntity) {
                        _livEnt = (LivingEntity)entityiterator;
                        itemStack32 = _livEnt.getOffhandItem();
                    } else {
                        itemStack32 = ItemStack.EMPTY;
                    }
                    double d11 = playerPosY + (playerPosY - (((CustomData)itemStack32.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("yPostion") + 0.5)) / (lcl_distance == 0.0 ? 0.01 : lcl_distance) * nb * -1.0;
                    if (entityiterator instanceof LivingEntity) {
                        _livEnt = (LivingEntity)entityiterator;
                        itemStack31 = _livEnt.getOffhandItem();
                    } else {
                        itemStack31 = ItemStack.EMPTY;
                    }
                    GrapplinWhiskChainsLineProcedure.renderItem(lcl_chains, d10, d11, playerPosZ + (playerPosZ - (((CustomData)itemStack31.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("zPostion") + 0.5)) / (lcl_distance == 0.0 ? 0.01 : lcl_distance) * nb * -1.0, (float)(Math.atan2(dx, dz) * -57.29577951308232 + 180.0), (float)(Math.atan2(dy, Math.abs(dx) + Math.abs(dz)) * 57.29577951308232), 0.0f, 1.0f, false, false);
                    nb += 0.5;
                }
            }
        }
    }
}

