/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.mod.client.chat.ClientTextConverter;
import su.plo.lib.mod.client.gui.widget.GuiWidgetTexture;
import su.plo.lib.mod.client.render.GlState;
import su.plo.lib.mod.client.render.VertexBuilder;
import su.plo.lib.mod.client.render.pipeline.RenderPipeline;
import su.plo.lib.mod.client.render.pipeline.RenderPipelines;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.voice.client.extension.TextKt;
import su.plo.voice.universal.TextBuilder;

public final class RenderUtil {
    private static final Font.DisplayMode TEXT_LAYER_TYPE = Font.DisplayMode.NORMAL;
    private static final ClientTextConverter TEXT_CONVERTER = new ClientTextConverter();
    private static boolean PRESERVE_GL_STATE = false;
    @Nullable
    private static GlState CURRENT_GL_STATE = null;
    @Nullable
    private static GlState OLD_GL_STATE = null;

    public static void enableScissor(int x, int y, int width, int height) {
        RenderSystem.enableScissor((int)x, (int)y, (int)width, (int)height);
    }

    public static void disableScissor() {
        RenderSystem.disableScissor();
    }

    public static void clearShader() {
        RenderSystem.setShader(() -> null);
    }

    @NotNull
    public static BufferBuilder beginBuffer(@NotNull RenderPipeline pipeline) {
        Tesselator tesselator = Tesselator.getInstance();
        return tesselator.begin(pipeline.getVertexFormatMode().toMc(), pipeline.getVertexFormat());
    }

    public static void setGlState(@NotNull GlState glState) {
        OLD_GL_STATE = glState.javaCopy();
        CURRENT_GL_STATE = glState;
        PRESERVE_GL_STATE = true;
    }

    public static void preserveGlState() {
        PRESERVE_GL_STATE = true;
    }

    public static void restoreGlState() {
        RenderUtil.restoreGlState(false);
    }

    public static void restoreGlState(boolean preserveGlState) {
        if (OLD_GL_STATE != null && CURRENT_GL_STATE != null) {
            OLD_GL_STATE.apply(CURRENT_GL_STATE);
        }
        CURRENT_GL_STATE = null;
        OLD_GL_STATE = null;
        PRESERVE_GL_STATE = preserveGlState;
    }

    private static void applyRenderPipeline(@NotNull RenderPipeline renderPipeline) {
        RenderSystem.setShader(renderPipeline.getShader()::invoke);
        if (CURRENT_GL_STATE == null) {
            CURRENT_GL_STATE = GlState.current();
            OLD_GL_STATE = CURRENT_GL_STATE.javaCopy();
        }
        renderPipeline.getGlState().apply(CURRENT_GL_STATE);
    }

    public static void drawBuffer(@NotNull BufferBuilder buffer, @NotNull RenderPipeline renderPipeline) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.applyRenderPipeline(renderPipeline);
        BufferUploader.drawWithShader((MeshData)buffer.build());
        if (!PRESERVE_GL_STATE) {
            RenderUtil.restoreGlState();
        }
        RenderUtil.clearShader();
    }

    public static void bindTexture(int index, @NotNull ResourceLocation location) {
        RenderSystem.setShaderTexture((int)index, (ResourceLocation)location);
    }

    public static void fill(PoseStack stack, int x0, int y0, int x1, int y1, int color) {
        RenderUtil.fill(stack, RenderPipelines.GUI_COLOR, x0, y0, x1, y1, color);
    }

    public static void fill(PoseStack stack, @NotNull RenderPipeline renderPipeline, int x0, int y0, int x1, int y1, int color) {
        int n;
        if (x0 < x1) {
            n = x0;
            x0 = x1;
            x1 = n;
        }
        if (y0 < y1) {
            n = y0;
            y0 = y1;
            y1 = n;
        }
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float h = (float)(color >> 8 & 0xFF) / 255.0f;
        float o = (float)(color & 0xFF) / 255.0f;
        BufferBuilder buffer = RenderUtil.beginBuffer(renderPipeline);
        VertexBuilder.create(buffer).position(stack, x0, y1, 0.0f).color(g, h, o, f).end();
        VertexBuilder.create(buffer).position(stack, x1, y1, 0.0f).color(g, h, o, f).end();
        VertexBuilder.create(buffer).position(stack, x1, y0, 0.0f).color(g, h, o, f).end();
        VertexBuilder.create(buffer).position(stack, x0, y0, 0.0f).color(g, h, o, f).end();
        RenderUtil.drawBuffer(buffer, renderPipeline);
    }

    public static void fillLight(PoseStack stack, @NotNull RenderPipeline renderPipeline, int x0, int y0, int x1, int y1, int color, int light) {
        int n;
        if (x0 < x1) {
            n = x0;
            x0 = x1;
            x1 = n;
        }
        if (y0 < y1) {
            n = y0;
            y0 = y1;
            y1 = n;
        }
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float h = (float)(color >> 8 & 0xFF) / 255.0f;
        float o = (float)(color & 0xFF) / 255.0f;
        BufferBuilder buffer = RenderUtil.beginBuffer(renderPipeline);
        VertexBuilder.create(buffer).position(stack, x0, y1, 0.0f).color(g, h, o, f).light(light).end();
        VertexBuilder.create(buffer).position(stack, x1, y1, 0.0f).color(g, h, o, f).light(light).end();
        VertexBuilder.create(buffer).position(stack, x1, y0, 0.0f).color(g, h, o, f).light(light).end();
        VertexBuilder.create(buffer).position(stack, x0, y0, 0.0f).color(g, h, o, f).light(light).end();
        RenderUtil.drawBuffer(buffer, renderPipeline);
    }

    public static void fillGradient(PoseStack stack, int startX, int startY, int endX, int endY, int colorStart, int colorEnd, int z) {
        int f = colorStart >> 24 & 0xFF;
        int g = colorStart >> 16 & 0xFF;
        int h = colorStart >> 8 & 0xFF;
        int i = colorStart & 0xFF;
        int j = colorEnd >> 24 & 0xFF;
        int k = colorEnd >> 16 & 0xFF;
        int l = colorEnd >> 8 & 0xFF;
        int m = colorEnd & 0xFF;
        RenderUtil.fillGradient(stack, startX, startY, endX, endY, g, h, i, f, k, l, m, j, z);
    }

    public static void fillGradient(PoseStack stack, int startX, int startY, int endX, int endY, int startRed, int startBlue, int startGreen, int startAlpha, int endRed, int endBlue, int endGreen, int endAlpha, int z) {
        RenderUtil.fillGradientWithPipeline(stack, RenderPipelines.GUI_COLOR, startX, startY, endX, endY, startRed, startBlue, startGreen, startAlpha, endRed, endBlue, endGreen, endAlpha, z);
    }

    public static void fillGradientWithPipeline(@NotNull PoseStack stack, @NotNull RenderPipeline renderPipeline, int startX, int startY, int endX, int endY, int startRed, int startBlue, int startGreen, int startAlpha, int endRed, int endBlue, int endGreen, int endAlpha, int z) {
        BufferBuilder buffer = RenderUtil.beginBuffer(renderPipeline);
        RenderUtil.fillGradient(stack, buffer, startX, startY, endX, endY, z, startRed, startBlue, startGreen, startAlpha, endRed, endBlue, endGreen, endAlpha);
        RenderUtil.drawBuffer(buffer, renderPipeline);
    }

    private static void fillGradient(PoseStack stack, BufferBuilder buffer, int startX, int startY, int endX, int endY, int z, int startRed, int startBlue, int startGreen, int startAlpha, int endRed, int endBlue, int endGreen, int endAlpha) {
        VertexBuilder.create(buffer).position(stack, endX, startY, z).color(startRed, startGreen, startBlue, startAlpha).end();
        VertexBuilder.create(buffer).position(stack, startX, startY, z).color(startRed, startGreen, startBlue, startAlpha).end();
        VertexBuilder.create(buffer).position(stack, startX, endY, z).color(endRed, endGreen, endBlue, endAlpha).end();
        VertexBuilder.create(buffer).position(stack, endX, endY, z).color(endRed, endGreen, endBlue, endAlpha).end();
    }

    public static void blitSprite(@NotNull PoseStack stack, @NotNull GuiWidgetTexture sprite, int x, int y, int u, int v, int width, int height) {
        RenderUtil.blit(stack, x, y, u + sprite.getU(), v + sprite.getV(), width, height, sprite.getTextureWidth(), sprite.getTextureHeight());
    }

    public static void blit(PoseStack stack, int x, int y, int u, int v, int width, int height) {
        RenderUtil.blit(stack, x, y, 0, (float)u, (float)v, width, height, 256, 256);
    }

    public static void blit(PoseStack stack, int x, int y, int z, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        RenderUtil.blitWithPipeline(stack, RenderPipelines.GUI_TEXTURE, x, y, z, u, v, width, height, textureWidth, textureHeight);
    }

    public static void blitWithPipeline(@NotNull PoseStack stack, @NotNull RenderPipeline pipeline, int x, int y, int z, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        RenderUtil.blitWithPipeline(stack, pipeline, x, x + width, y, y + height, z, width, height, u, v, textureWidth, textureHeight);
    }

    public static void blit(PoseStack stack, int x, int y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        RenderUtil.blitWithPipeline(stack, RenderPipelines.GUI_TEXTURE, x, y, width, height, u, v, regionWidth, regionHeight, textureWidth, textureHeight);
    }

    public static void blitWithPipeline(@NotNull PoseStack stack, @NotNull RenderPipeline pipeline, int x, int y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        RenderUtil.blitWithPipeline(stack, pipeline, x, x + width, y, y + height, 0, regionWidth, regionHeight, u, v, textureWidth, textureHeight);
    }

    public static void blit(PoseStack stack, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        RenderUtil.blitWithPipeline(stack, RenderPipelines.GUI_TEXTURE, x, y, u, v, width, height, textureWidth, textureHeight);
    }

    public static void blitWithPipeline(@NotNull PoseStack stack, @NotNull RenderPipeline pipeline, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        RenderUtil.blitWithPipeline(stack, pipeline, x, y, width, height, u, v, width, height, textureWidth, textureHeight);
    }

    public static void blit(PoseStack stack, int x0, int x1, int y0, int y1, int z, int regionWidth, int regionHeight, float u, float v, int textureWidth, int textureHeight) {
        RenderUtil.blitWithPipeline(stack, RenderPipelines.GUI_TEXTURE, x0, x1, y0, y1, z, regionWidth, regionHeight, u, v, textureWidth, textureHeight);
    }

    public static void blitWithPipeline(@NotNull PoseStack stack, @NotNull RenderPipeline pipeline, int x0, int x1, int y0, int y1, int z, int regionWidth, int regionHeight, float u, float v, int textureWidth, int textureHeight) {
        RenderUtil.blitWithPipeline(stack, pipeline, x0, x1, y0, y1, z, (u + 0.0f) / (float)textureWidth, (u + (float)regionWidth) / (float)textureWidth, (v + 0.0f) / (float)textureHeight, (v + (float)regionHeight) / (float)textureHeight);
    }

    public static void blit(PoseStack stack, int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1) {
        RenderUtil.blitWithPipeline(stack, RenderPipelines.GUI_TEXTURE, x0, x1, y0, y1, z, u0, u1, v0, v1);
    }

    public static void blitWithPipeline(@NotNull PoseStack stack, @NotNull RenderPipeline pipeline, int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1) {
        BufferBuilder buffer = RenderUtil.beginBuffer(pipeline);
        VertexBuilder.create(buffer).position(stack, x0, y1, z).uv(u0, v1).end();
        VertexBuilder.create(buffer).position(stack, x1, y1, z).uv(u1, v1).end();
        VertexBuilder.create(buffer).position(stack, x1, y0, z).uv(u1, v0).end();
        VertexBuilder.create(buffer).position(stack, x0, y0, z).uv(u0, v0).end();
        RenderUtil.drawBuffer(buffer, pipeline);
    }

    public static void blitColorSprite(@NotNull PoseStack stack, @NotNull RenderPipeline pipeline, @NotNull GuiWidgetTexture sprite, int x, int y, int u, int v, int width, int height, int red, int green, int blue, int alpha) {
        RenderUtil.blitColorWithPipeline(stack, pipeline, x, y, u + sprite.getU(), v + sprite.getV(), width, height, sprite.getTextureWidth(), sprite.getTextureHeight(), red, green, blue, alpha);
    }

    public static void blitColorWithPipeline(@NotNull PoseStack stack, @NotNull RenderPipeline pipeline, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight, int red, int green, int blue, int alpha) {
        RenderUtil.blitColorWithPipeline(stack, pipeline, x, y, u, v, width, height, width, height, textureWidth, textureHeight, red, green, blue, alpha);
    }

    public static void blitColorWithPipeline(@NotNull PoseStack stack, @NotNull RenderPipeline pipeline, int x, int y, float u, float v, int width, int height, int regionWidth, int regionHeight, int textureWidth, int textureHeight, int red, int green, int blue, int alpha) {
        RenderUtil.blitColorWithPipeline(stack, pipeline, x, x + width, y, y + height, 0, regionWidth, regionHeight, u, v, textureWidth, textureHeight, red, green, blue, alpha);
    }

    public static void blitColorWithPipeline(@NotNull PoseStack stack, @NotNull RenderPipeline pipeline, int x0, int x1, int y0, int y1, int z, int regionWidth, int regionHeight, float u, float v, int textureWidth, int textureHeight, int red, int green, int blue, int alpha) {
        RenderUtil.blitColorWithPipeline(stack, pipeline, x0, x1, y0, y1, z, (u + 0.0f) / (float)textureWidth, (u + (float)regionWidth) / (float)textureWidth, (v + 0.0f) / (float)textureHeight, (v + (float)regionHeight) / (float)textureHeight, red, green, blue, alpha);
    }

    public static void blitColorWithPipeline(@NotNull PoseStack stack, @NotNull RenderPipeline pipeline, int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1, int red, int green, int blue, int alpha) {
        BufferBuilder buffer = RenderUtil.beginBuffer(pipeline);
        VertexBuilder.create(buffer).position(stack, x0, y1, z).uv(u0, v1).color(red, green, blue, alpha).end();
        VertexBuilder.create(buffer).position(stack, x1, y1, z).uv(u1, v1).color(red, green, blue, alpha).end();
        VertexBuilder.create(buffer).position(stack, x1, y0, z).uv(u1, v0).color(red, green, blue, alpha).end();
        VertexBuilder.create(buffer).position(stack, x0, y0, z).uv(u0, v0).color(red, green, blue, alpha).end();
        RenderUtil.drawBuffer(buffer, pipeline);
    }

    public static void blitColor(PoseStack stack, int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1, int red, int green, int blue, int alpha) {
        RenderUtil.blitColorWithPipeline(stack, RenderPipelines.GUI_TEXTURE_COLOR, x0, x1, y0, y1, z, u0, u1, v0, v1, red, green, blue, alpha);
    }

    public static void drawStringInBatch(PoseStack stack, String text, int x, int y, int color, boolean shadow) {
        MultiBufferSource.BufferSource irendertypebuffer$impl = Minecraft.getInstance().renderBuffers().bufferSource();
        Minecraft.getInstance().font.drawInBatch(text, (float)x, (float)y, color, shadow, stack.last().pose(), (MultiBufferSource)irendertypebuffer$impl, TEXT_LAYER_TYPE, 0, 0xF000F0);
        irendertypebuffer$impl.endBatch();
        if (CURRENT_GL_STATE != null) {
            CURRENT_GL_STATE.setDepthFunc(null);
            CURRENT_GL_STATE.setBlendFunc(null);
        }
    }

    public static int drawCenteredString(PoseStack stack, String string, int x, int y, int color) {
        return RenderUtil.drawCenteredString(stack, string, x, y, color, true);
    }

    public static int drawCenteredString(PoseStack stack, String string, int x, int y, int color, boolean dropShadow) {
        color = RenderUtil.adjustColor(color);
        int centeredX = x - RenderUtil.getStringWidth(string) / 2;
        RenderUtil.drawStringInBatch(stack, string, centeredX, y, color, dropShadow);
        return RenderUtil.getStringX(string, centeredX, dropShadow);
    }

    public static int drawCenteredString(PoseStack stack, McTextComponent text, int x, int y, int color) {
        return RenderUtil.drawCenteredString(stack, RenderUtil.getFormattedString(text), x, y, color);
    }

    public static void drawCenteredOrderedString(PoseStack stack, McTextComponent text, int width, int x, int y, int color) {
        RenderUtil.drawCenteredOrderedString(stack, text, width, x, y, color, true);
    }

    public static void drawCenteredOrderedString(PoseStack stack, McTextComponent text, int width, int x, int y, int color, boolean dropShadow) {
        color = RenderUtil.adjustColor(color);
        String orderedText = RenderUtil.getOrderedString(text, width);
        RenderUtil.drawStringInBatch(stack, orderedText, x - RenderUtil.getStringWidth(orderedText) / 2, y, color, dropShadow);
    }

    public static void drawOrderedString(PoseStack stack, McTextComponent text, int width, int x, int y, int color) {
        RenderUtil.drawOrderedString(stack, text, width, x, y, color, true);
    }

    public static void drawOrderedString(PoseStack stack, McTextComponent text, int width, int x, int y, int color, boolean dropShadow) {
        color = RenderUtil.adjustColor(color);
        RenderUtil.drawStringInBatch(stack, RenderUtil.getOrderedString(text, width), x, y, color, dropShadow);
    }

    public static int drawString(PoseStack stack, String string, int x, int y, int color) {
        return RenderUtil.drawString(stack, string, x, y, color, false);
    }

    public static int drawString(PoseStack stack, String string, int x, int y, int color, boolean dropShadow) {
        color = RenderUtil.adjustColor(color);
        RenderUtil.drawStringInBatch(stack, string, x, y, color, dropShadow);
        return RenderUtil.getStringX(string, x, dropShadow);
    }

    public static int drawString(PoseStack stack, McTextComponent text, int x, int y, int color) {
        return RenderUtil.drawString(stack, text, x, y, color, true);
    }

    public static int drawString(PoseStack stack, McTextComponent text, int x, int y, int color, boolean dropShadow) {
        color = RenderUtil.adjustColor(color);
        String formattedText = RenderUtil.getFormattedString(text);
        RenderUtil.drawStringInBatch(stack, formattedText, x, y, color, dropShadow);
        return RenderUtil.getStringX(formattedText, x, dropShadow);
    }

    public static int drawStringLight(PoseStack stack, McTextComponent text, int x, int y, int color, int light, boolean seeThrough, boolean dropShadow) {
        color = RenderUtil.adjustColor(color);
        String formattedText = RenderUtil.getFormattedString(text);
        Font.DisplayMode displayMode = seeThrough ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL;
        MultiBufferSource.BufferSource irendertypebuffer$impl = Minecraft.getInstance().renderBuffers().bufferSource();
        Minecraft.getInstance().font.drawInBatch(formattedText, (float)x, (float)y, color, dropShadow, stack.last().pose(), (MultiBufferSource)irendertypebuffer$impl, displayMode, 0, light);
        irendertypebuffer$impl.endBatch();
        return RenderUtil.getStringX(formattedText, x, dropShadow);
    }

    public static int drawStringMultiLine(PoseStack stack, McTextComponent text, int x, int y, int color, int width) {
        return RenderUtil.drawStringMultiLine(stack, text, x, y, color, width, true);
    }

    public static int drawStringMultiLine(PoseStack stack, McTextComponent text, int x, int y, int color, int width, boolean dropShadow) {
        color = RenderUtil.adjustColor(color);
        String string = RenderUtil.getFormattedString(text);
        List<String> lines = TextKt.getStringSplitToWidth(string, width, true, true);
        int lineHeight = RenderUtil.getFontHeight();
        for (String orderedText : lines) {
            RenderUtil.drawStringInBatch(stack, orderedText, x, y - lineHeight - 1, color, dropShadow);
            y += lineHeight;
        }
        return lines.size();
    }

    public static int drawStringMultiLineCentered(PoseStack stack, McTextComponent text, int width, int y, int yGap, int color) {
        return RenderUtil.drawStringMultiLineCentered(stack, text, width, y, yGap, color, true);
    }

    public static int drawStringMultiLineCentered(PoseStack stack, McTextComponent text, int width, int y, int yGap, int color, boolean dropShadow) {
        color = RenderUtil.adjustColor(color);
        String string = RenderUtil.getFormattedString(text);
        List<String> lines = TextKt.getStringSplitToWidth(string, width, true, true);
        int lineHeight = RenderUtil.getFontHeight();
        for (String orderedText : lines) {
            RenderUtil.drawStringInBatch(stack, orderedText, width / 2 - RenderUtil.getStringWidth(orderedText) / 2, y + lineHeight, color, dropShadow);
            y += lineHeight + yGap;
        }
        return lines.size();
    }

    public static int getStringX(String string, int x, boolean dropShadow) {
        return x + RenderUtil.getStringWidth(string) + (dropShadow ? 1 : 0);
    }

    public static int adjustColor(int color) {
        return (color & 0xFC000000) == 0 ? color | 0xFF000000 : color;
    }

    public static String stringToWidth(String string, int width, boolean tail) {
        return RenderUtil.stringToWidth(string, width, tail, "...");
    }

    public static String stringToWidth(String string, int width, boolean tail, String trimmedTextSuffix) {
        List<String> lines = TextKt.splitStringToWidthTruncated(string, width, 1, false, true, trimmedTextSuffix);
        return lines.get(tail ? lines.size() - 1 : 0);
    }

    public static String stringToWidth(String string, int width) {
        return RenderUtil.stringToWidth(string, width, false);
    }

    public static int getTextWidth(McTextComponent text) {
        return RenderUtil.getStringWidth(RenderUtil.getFormattedString(text));
    }

    public static String getOrderedString(McTextComponent text, int width) {
        return TextKt.getTruncatedString(RenderUtil.getFormattedString(text), width, "...");
    }

    public static String getFormattedString(McTextComponent text) {
        Component component = RenderUtil.getTextConverter().convert(text);
        TextBuilder textBuilder = new TextBuilder(true);
        component.getVisualOrderText().accept((FormattedCharSink)textBuilder);
        return textBuilder.getString();
    }

    public static int getStringWidth(String string) {
        return Minecraft.getInstance().font.width(string);
    }

    public static int getFontHeight() {
        Objects.requireNonNull(Minecraft.getInstance().font);
        return 9;
    }

    public static ClientTextConverter getTextConverter() {
        return TEXT_CONVERTER;
    }

    private RenderUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

