/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import ht.treechop.TreeChopException;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.util.LevelUtil;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ServerCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"treechop").requires(source -> source.hasPermission(2));
        builder.then(Commands.literal((String)"chop").then(Commands.argument((String)"chopPos", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"chopCount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ServerCommands::chop))));
        builder.then(Commands.literal((String)"fell").then(Commands.argument((String)"chopPos", (ArgumentType)BlockPosArgument.blockPos()).executes(ServerCommands::fell)));
        dispatcher.register(builder);
    }

    private static int chop(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        BlockPos pos = ((Coordinates)context.getArgument("chopPos", Coordinates.class)).getBlockPos(source);
        int numChops = (Integer)context.getArgument("chopCount", Integer.class);
        ServerCommands.chop(context, source, pos, numChops);
        return 1;
    }

    private static void chop(CommandContext<CommandSourceStack> context, CommandSourceStack source, BlockPos pos, int numChops) {
        try {
            boolean felled;
            boolean bl = felled = !ChopUtil.chop(source.getPlayer(), source.getLevel(), pos, source.getLevel().getBlockState(pos), ItemStack.EMPTY, context, numChops, false);
            if (felled) {
                LevelUtil.harvestBlock((Entity)source.getPlayer(), (Level)source.getLevel(), pos, ItemStack.EMPTY, true);
            }
        }
        catch (TreeChopException treeChopException) {
            // empty catch block
        }
    }

    private static int fell(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        BlockPos pos = ((Coordinates)context.getArgument("chopPos", Coordinates.class)).getBlockPos(source);
        ServerCommands.chop(context, source, pos, 10000);
        return 1;
    }
}

