/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.mixin;

import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.settings.ChoppingEntity;
import ht.treechop.common.settings.SyncedChopData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityChopSettingsMixin
implements ChoppingEntity {
    private SyncedChopData chopSettings;
    private final String KEY = "treechop:chopSettings";

    @Override
    public SyncedChopData getChopData() {
        return this.chopSettings;
    }

    @Override
    public SyncedChopData setChopData(SyncedChopData chopSettings) {
        this.chopSettings = chopSettings;
        return chopSettings;
    }

    @Inject(method={"saveWithoutId"}, at={@At(value="HEAD")}, remap=false)
    public void injectDataSaving(CompoundTag tag, CallbackInfoReturnable<CompoundTag> info) {
        if (this.chopSettings != null) {
            tag.put("treechop:chopSettings", (Tag)this.chopSettings.makeSaveData());
        }
    }

    @Inject(method={"load"}, at={@At(value="HEAD")}, remap=false)
    public void injectDataLoading(CompoundTag tag, CallbackInfo info) {
        CompoundTag data = tag.getCompound("treechop:chopSettings");
        this.chopSettings = new SyncedChopData(new ChopSettings()).readSaveData(data);
    }
}

