/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.block;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public abstract class BlockImitator
extends Block {
    public BlockImitator(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public abstract BlockState getImitatedBlockState(BlockGetter var1, BlockPos var2);

    public void animateTick(BlockState blockState, Level level, BlockPos pos, RandomSource random) {
        BlockState imitatedBlockState = this.getImitatedBlockState((BlockGetter)level, pos);
        imitatedBlockState.getBlock().animateTick(imitatedBlockState, level, pos, random);
    }

    public void stepOn(Level level, BlockPos pos, BlockState blockState, Entity entity) {
        BlockState imitatedBlockState = this.getImitatedBlockState((BlockGetter)level, pos);
        imitatedBlockState.getBlock().stepOn(level, pos, imitatedBlockState, entity);
    }

    public void fallOn(Level level, BlockState blockState, BlockPos pos, Entity entity, float speed) {
        BlockState imitatedBlockState = this.getImitatedBlockState((BlockGetter)level, pos);
        imitatedBlockState.getBlock().fallOn(level, imitatedBlockState, pos, entity, speed);
    }

    @NotNull
    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState blockState) {
        BlockState imitatedBlockState = this.getImitatedBlockState((BlockGetter)level, pos);
        return imitatedBlockState.getBlock().getCloneItemStack(level, pos, imitatedBlockState);
    }

    public void handlePrecipitation(BlockState blockState, Level level, BlockPos pos, Biome.Precipitation precipitation) {
        BlockState imitatedBlockState = this.getImitatedBlockState((BlockGetter)level, pos);
        imitatedBlockState.getBlock().handlePrecipitation(imitatedBlockState, level, pos, precipitation);
    }

    public int getLightBlock(BlockState blockState, BlockGetter level, BlockPos pos) {
        return super.getLightBlock(blockState, level, pos);
    }

    public float getShadeBrightness(BlockState blockState, BlockGetter level, BlockPos pos) {
        return super.getShadeBrightness(blockState, level, pos);
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return this.getImitatedBlockState((BlockGetter)level, pos).getAnalogOutputSignal(level, pos);
    }

    public void randomTick(BlockState blockState, ServerLevel level, BlockPos pos, RandomSource random) {
        this.getImitatedBlockState((BlockGetter)level, pos).randomTick(level, pos, random);
    }

    public void tick(BlockState blockState, ServerLevel level, BlockPos pos, RandomSource random) {
        this.getImitatedBlockState((BlockGetter)level, pos).tick(level, pos, random);
    }

    public int getSignal(BlockState blockState, BlockGetter level, BlockPos pos, Direction direction) {
        return this.getImitatedBlockState(level, pos).getSignal(level, pos, direction);
    }

    public int getDirectSignal(BlockState blockState, BlockGetter level, BlockPos pos, Direction direction) {
        return this.getImitatedBlockState(level, pos).getDirectSignal(level, pos, direction);
    }
}

