/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common;

import ht.treechop.api.ChopData;
import ht.treechop.api.ChopDataImmutable;
import ht.treechop.api.ChopEvent;
import ht.treechop.api.FellData;
import ht.treechop.api.TreeData;
import ht.treechop.common.NeoForgeRegistry;
import ht.treechop.common.chop.ChopResult;
import ht.treechop.common.chop.FellTreeResult;
import ht.treechop.common.platform.ModLoader;
import ht.treechop.common.platform.Platform;
import ht.treechop.common.util.TreeDataImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.NeoForge;

public class NeoForgePlatform
implements Platform {
    @Override
    public boolean isDedicatedServer() {
        return FMLEnvironment.dist.isDedicatedServer();
    }

    @Override
    public boolean uses(ModLoader loader) {
        return loader == ModLoader.FORGE;
    }

    @Override
    public TreeData detectTreeEvent(Level level, ServerPlayer agent, BlockPos blockPos, BlockState blockState, TreeData treeData) {
        ChopEvent.DetectTreeEvent event = new ChopEvent.DetectTreeEvent(level, agent, blockPos, blockState, treeData);
        NeoForge.EVENT_BUS.post((Event)event);
        treeData = event.getTreeData().orElse(null);
        return event.isCanceled() || treeData == null ? TreeDataImpl.empty(level) : treeData;
    }

    @Override
    public boolean startChopEvent(ServerPlayer agent, ServerLevel level, BlockPos pos, BlockState blockState, ChopData chopData, Object trigger) {
        ChopEvent.StartChopEvent startChopEvent = new ChopEvent.StartChopEvent((Level)level, agent, pos, blockState, chopData, trigger);
        NeoForge.EVENT_BUS.post((Event)startChopEvent);
        return !startChopEvent.isCanceled();
    }

    @Override
    public void finishChopEvent(ServerPlayer agent, ServerLevel level, BlockPos pos, BlockState blockState, ChopDataImmutable chopData, ChopResult chopResult) {
        NeoForge.EVENT_BUS.post((Event)new ChopEvent.FinishChopEvent((Level)level, (Player)agent, pos, blockState, chopData, chopResult instanceof FellTreeResult));
    }

    @Override
    public boolean startFellTreeEvent(ServerPlayer player, Level level, BlockPos choppedPos, FellData fellData) {
        ChopEvent.BeforeFellEvent beforeFellEvent = new ChopEvent.BeforeFellEvent(level, player, choppedPos, level.getBlockState(choppedPos), fellData);
        NeoForge.EVENT_BUS.post((Event)beforeFellEvent);
        return !beforeFellEvent.isCanceled();
    }

    @Override
    public void finishFellTreeEvent(ServerPlayer player, Level level, BlockPos choppedPos, FellData fellData) {
        ChopEvent.AfterFellEvent afterFellEvent = new ChopEvent.AfterFellEvent(level, player, choppedPos, level.getBlockState(choppedPos), fellData);
    }

    @Override
    public Block getChoppedLogBlock() {
        return (Block)NeoForgeRegistry.Blocks.CHOPPED_LOG.get();
    }

    @Override
    public BlockEntityType<?> getChoppedLogBlockEntity() {
        return (BlockEntityType)NeoForgeRegistry.BlockEntities.CHOPPED_LOG_ENTITY.get();
    }

    @Override
    public ResourceLocation getResourceLocationForBlock(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    @Override
    public ResourceLocation getResourceLocationForItem(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    @Override
    public BlockState getStrippedState(BlockAndTintGetter level, BlockPos pos, BlockState state) {
        try {
            if (level instanceof Level) {
                Level realLevel = (Level)level;
                BlockHitResult fakeHitResult = BlockHitResult.miss((Vec3)Vec3.ZERO, (Direction)Direction.DOWN, (BlockPos)pos);
                return state.getToolModifiedState(new UseOnContext(realLevel, null, InteractionHand.MAIN_HAND, ItemStack.EMPTY, fakeHitResult), ItemAbilities.AXE_STRIP, true);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }
}

