/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common;

import ht.treechop.TreeChop;
import ht.treechop.TreeChopException;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.config.ConfigHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="treechop", bus=EventBusSubscriber.Bus.GAME)
public class NeoForgeCommon {
    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        ConfigHandler.updateTags();
    }

    @SubscribeEvent
    public static void onBreakEvent(BlockEvent.BreakEvent event) {
        ServerLevel level;
        LevelAccessor levelAccessor;
        block8: {
            block7: {
                if (event.isCanceled() || !((levelAccessor = event.getLevel()) instanceof ServerLevel)) break block7;
                level = (ServerLevel)levelAccessor;
                levelAccessor = event.getPlayer();
                if (levelAccessor instanceof ServerPlayer) break block8;
            }
            return;
        }
        ServerPlayer agent = (ServerPlayer)levelAccessor;
        ItemStack tool = agent.getMainHandItem();
        BlockState blockState = event.getState();
        BlockPos pos = event.getPos();
        try {
            if (ChopUtil.chop(agent, level, pos, blockState, tool, event)) {
                event.setCanceled(true);
            }
        }
        catch (TreeChopException e) {
            TreeChop.cry(e);
        }
    }
}

